/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOfDayConditionHandler
extends BaseModuleHandler<Condition>
implements ConditionHandler {
    private final Logger logger = LoggerFactory.getLogger(TimeOfDayConditionHandler.class);
    public static final String MODULE_TYPE_ID = "core.TimeOfDayCondition";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private final LocalTime startTime;
    private final LocalTime endTime;

    public TimeOfDayConditionHandler(Condition condition) {
        super((Module)condition);
        Configuration configuration = ((Condition)this.module).getConfiguration();
        String startTimeConfig = (String)configuration.get(START_TIME);
        String endTimeConfig = (String)configuration.get(END_TIME);
        this.startTime = startTimeConfig == null ? null : LocalTime.parse(startTimeConfig).truncatedTo(ChronoUnit.MINUTES);
        this.endTime = endTimeConfig == null ? null : LocalTime.parse(endTimeConfig).truncatedTo(ChronoUnit.MINUTES);
    }

    public boolean isSatisfied(Map<String, Object> inputs) {
        if (this.startTime == null || this.endTime == null) {
            this.logger.warn("Time condition with id {} is not well configured: startTime={}  endTime = {}", new Object[]{((Condition)this.module).getId(), this.startTime, this.endTime});
            return false;
        }
        LocalTime currentTime = LocalTime.now().truncatedTo(ChronoUnit.MINUTES);
        if (currentTime.equals(this.startTime)) {
            this.logger.debug("Time condition with id {} evaluated, that the current time {} equals the start time: {}", new Object[]{((Condition)this.module).getId(), currentTime, this.startTime});
            return true;
        }
        if (this.startTime.isBefore(this.endTime)) {
            if (currentTime.isAfter(this.startTime) && currentTime.isBefore(this.endTime)) {
                this.logger.debug("Time condition with id {} evaluated, that {} is between {} and {}.", new Object[]{((Condition)this.module).getId(), currentTime, this.startTime, this.endTime});
                return true;
            }
        } else if (currentTime.isAfter(LocalTime.MIDNIGHT) && currentTime.isBefore(this.endTime) || currentTime.isAfter(this.startTime) && currentTime.isBefore(LocalTime.MAX)) {
            this.logger.debug("Time condition with id {} evaluated, that {} is between {} and {}, or between {} and {}.", new Object[]{((Condition)this.module).getId(), currentTime, LocalTime.MIDNIGHT, this.endTime, this.startTime, LocalTime.MAX.truncatedTo(ChronoUnit.MINUTES)});
            return true;
        }
        return false;
    }
}

