/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.handler;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.binding.astro.AstroBindingConstants;
import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.calc.MoonCalc;
import org.eclipse.smarthome.binding.astro.internal.job.DailyJobMoon;
import org.eclipse.smarthome.binding.astro.internal.job.Job;
import org.eclipse.smarthome.binding.astro.internal.model.Moon;
import org.eclipse.smarthome.binding.astro.internal.model.Planet;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

public class MoonHandler
extends AstroThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(AstroBindingConstants.THING_TYPE_MOON));
    private final String[] positionalChannelIds = new String[]{"phase#name", "phase#age", "phase#agePercent", "phase#ageDegree", "phase#illumination", "position#azimuth", "position#elevation", "zodiac#sign"};
    private final MoonCalc moonCalc = new MoonCalc();
    private Moon moon;

    public MoonHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void publishDailyInfo() {
        this.initializeMoon();
        this.publishPositionalInfo();
    }

    @Override
    public void publishPositionalInfo() {
        this.initializeMoon();
        this.moonCalc.setPositionalInfo(Calendar.getInstance(), this.thingConfig.getLatitude(), this.thingConfig.getLongitude(), this.moon);
        this.publishPlanet();
    }

    @Override
    public Planet getPlanet() {
        return this.moon;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.moon = null;
    }

    @Override
    protected String[] getPositionalChannelIds() {
        return this.positionalChannelIds;
    }

    @Override
    protected Job getDailyJob() {
        return new DailyJobMoon(this.thing.getUID().getAsString(), this);
    }

    private void initializeMoon() {
        this.moon = this.moonCalc.getMoonInfo(Calendar.getInstance(), this.thingConfig.getLatitude(), this.thingConfig.getLongitude());
    }
}

