/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.config.AstroChannelConfig;
import org.eclipse.smarthome.binding.astro.internal.job.CompositeJob;
import org.eclipse.smarthome.binding.astro.internal.job.EventJob;
import org.eclipse.smarthome.binding.astro.internal.job.PublishPlanetJob;
import org.eclipse.smarthome.binding.astro.internal.job.SunPhaseJob;
import org.eclipse.smarthome.binding.astro.internal.model.Range;
import org.eclipse.smarthome.binding.astro.internal.model.SunPhaseName;
import org.eclipse.smarthome.binding.astro.internal.util.DateTimeUtils;
import org.eclipse.smarthome.core.thing.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Job
extends Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void schedule(String thingUID, AstroThingHandler astroHandler, Job job, Calendar eventAt) {
        try {
            Calendar today = Calendar.getInstance();
            if (DateTimeUtils.isSameDay(eventAt, today) && DateTimeUtils.isTimeGreaterEquals(eventAt, today)) {
                astroHandler.schedule(job, eventAt);
            }
        }
        catch (Exception ex) {
            LOGGER.error("{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public static void scheduleEvent(String thingUID, AstroThingHandler astroHandler, Calendar eventAt, String event, String channelId, boolean configAlreadyApplied) {
        Job.scheduleEvent(thingUID, astroHandler, eventAt, Collections.singletonList(event), channelId, configAlreadyApplied);
    }

    public static void scheduleEvent(String thingUID, AstroThingHandler astroHandler, Calendar eventAt, List<String> events, String channelId, boolean configAlreadyApplied) {
        Calendar instant;
        boolean thingNull = Job.checkNull(thingUID, "Thing UID is null");
        boolean astroHandlerNull = Job.checkNull(astroHandler, "AstroThingHandler is null");
        boolean eventAtNull = Job.checkNull(eventAt, "Scheduled Instant is null");
        boolean eventsNull = Job.checkNull(events, "Events list is null");
        boolean channelIdNull = Job.checkNull(channelId, "Channel ID is null");
        if (thingNull || astroHandlerNull || eventAtNull || eventsNull || channelIdNull || events.isEmpty()) {
            return;
        }
        if (!configAlreadyApplied) {
            Channel channel = astroHandler.getThing().getChannel(channelId);
            if (channel == null) {
                LOGGER.warn("Cannot find channel '{}' for thing '{}'.", (Object)channelId, (Object)astroHandler.getThing().getUID());
                return;
            }
            AstroChannelConfig config = (AstroChannelConfig)channel.getConfiguration().as(AstroChannelConfig.class);
            instant = DateTimeUtils.applyConfig(eventAt, config);
        } else {
            instant = eventAt;
        }
        List<Job> jobs = events.stream().map(e -> new EventJob(thingUID, channelId, (String)e)).collect(Collectors.toList());
        Job.schedule(thingUID, astroHandler, new CompositeJob(thingUID, jobs), instant);
    }

    public static void scheduleRange(String thingUID, AstroThingHandler astroHandler, Range range, String channelId) {
        Calendar configEnd;
        boolean thingNull = Job.checkNull(thingUID, "Thing UID is null");
        boolean astroHandlerNull = Job.checkNull(astroHandler, "AstroThingHandler is null");
        boolean rangeNull = Job.checkNull(range, "Range is null");
        boolean channelIdNull = Job.checkNull(channelId, "Channel ID is null");
        if (thingNull || astroHandlerNull || rangeNull || channelIdNull) {
            return;
        }
        Calendar start = range.getStart();
        Calendar end = range.getEnd();
        if (start == null || end == null) {
            return;
        }
        Channel channel = astroHandler.getThing().getChannel(channelId);
        if (channel == null) {
            LOGGER.warn("Cannot find channel '{}' for thing '{}'.", (Object)channelId, (Object)astroHandler.getThing().getUID());
            return;
        }
        AstroChannelConfig config = (AstroChannelConfig)channel.getConfiguration().as(AstroChannelConfig.class);
        Calendar configStart = DateTimeUtils.applyConfig(start, config);
        if (DateUtils.truncatedEquals((Calendar)configStart, (Calendar)(configEnd = DateTimeUtils.applyConfig(end, config)), (int)13)) {
            Job.scheduleEvent(thingUID, astroHandler, configStart, Arrays.asList("START", "END"), channelId, true);
        } else {
            Job.scheduleEvent(thingUID, astroHandler, configStart, "START", channelId, true);
            Job.scheduleEvent(thingUID, astroHandler, configEnd, "END", channelId, true);
        }
    }

    public static void schedulePublishPlanet(String thingUID, AstroThingHandler astroHandler, Calendar eventAt) {
        boolean thingNull = Job.checkNull(thingUID, "Thing UID is null");
        boolean astroHandlerNull = Job.checkNull(astroHandler, "AstroThingHandler is null");
        boolean eventAtNull = Job.checkNull(eventAt, "Scheduled Instant is null");
        if (thingNull || astroHandlerNull || eventAtNull) {
            return;
        }
        PublishPlanetJob publishJob = new PublishPlanetJob(thingUID);
        Job.schedule(thingUID, astroHandler, publishJob, eventAt);
    }

    public static void scheduleSunPhase(String thingUID, AstroThingHandler astroHandler, SunPhaseName sunPhaseName, Calendar eventAt) {
        boolean thingNull = Job.checkNull(thingUID, "Thing UID is null");
        boolean astroHandlerNull = Job.checkNull(astroHandler, "AstroThingHandler is null");
        boolean sunPhaseNull = Job.checkNull(sunPhaseName, "Sun Phase Name is null");
        boolean eventAtNull = Job.checkNull(eventAt, "Scheduled Instant is null");
        if (thingNull || astroHandlerNull || sunPhaseNull || eventAtNull) {
            return;
        }
        SunPhaseJob sunPhaseJob = new SunPhaseJob(thingUID, sunPhaseName);
        Job.schedule(thingUID, astroHandler, sunPhaseJob, eventAt);
    }

    public static <T> boolean checkNull(T obj, String message) {
        if (Objects.isNull(obj)) {
            LOGGER.trace("{}", (Object)message);
            return true;
        }
        return false;
    }

    public String getThingUID();
}

