/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.bluez.internal.discovery;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.bluetooth.bluez.BlueZAdapterConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tinyb.BluetoothAdapter;
import tinyb.BluetoothManager;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.bluetooth.bluez")
public class BlueZDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(BlueZDiscoveryService.class);
    private BluetoothManager manager;

    public BlueZDiscoveryService() {
        super(Collections.singleton(BlueZAdapterConstants.THING_TYPE_BLUEZ), 1, true);
    }

    @Activate
    protected void activate(@Nullable Map<@NonNull String, @Nullable Object> configProperties) {
        this.modified(configProperties);
    }

    @Modified
    protected void modified(@Nullable Map<@NonNull String, @Nullable Object> configProperties) {
        super.modified(configProperties);
        if (this.isBackgroundDiscoveryEnabled()) {
            this.startScan();
        }
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    protected void startScan() {
        try {
            this.manager = BluetoothManager.getBluetoothManager();
            this.manager.getAdapters().stream().map(this::createDiscoveryResult).forEach(arg_0 -> ((BlueZDiscoveryService)this).thingDiscovered(arg_0));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return;
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("AccessDenied")) {
                this.logger.error("Cannot access BlueZ stack due to permission problems. Make sure that your OS user is part of the 'bluetooth' group of BlueZ.");
            }
            this.logger.error("Failed to scan for Bluetooth devices: {}", (Object)e.getMessage());
        }
    }

    private DiscoveryResult createDiscoveryResult(BluetoothAdapter adapter) {
        return DiscoveryResultBuilder.create((ThingUID)new ThingUID(BlueZAdapterConstants.THING_TYPE_BLUEZ, this.getId(adapter))).withLabel("Bluetooth Interface " + adapter.getName()).withProperty("address", (Object)adapter.getAddress()).withRepresentationProperty("address").build();
    }

    private String getId(BluetoothAdapter adapter) {
        return adapter.getInterfaceName().replaceAll("[^a-zA-Z0-9_]", "");
    }
}

