/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bosesoundtouch.internal.discovery;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.jmdns.ServiceInfo;
import org.eclipse.smarthome.binding.bosesoundtouch.BoseSoundTouchBindingConstants;
import org.eclipse.smarthome.binding.bosesoundtouch.internal.discovery.DiscoveryUtil;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.mdns.MDNSDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"discovery.bosesoundtouch"})
public class SoundTouchDiscoveryParticipant
implements MDNSDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(SoundTouchDiscoveryParticipant.class);

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return BoseSoundTouchBindingConstants.SUPPORTED_THING_TYPES_UIDS;
    }

    public DiscoveryResult createResult(ServiceInfo info) {
        DiscoveryResult result = null;
        ThingUID uid = this.getThingUID(info);
        if (uid != null) {
            Object[] addrs = info.getInetAddresses();
            HashMap<String, String> properties = new HashMap<String, String>(2);
            String label = null;
            if (BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID.equals((Object)uid.getThingTypeUID())) {
                try {
                    String group = DiscoveryUtil.executeUrl("http://" + addrs[0].getHostAddress() + ":8090/getGroup");
                    label = DiscoveryUtil.getContentOfFirstElement(group, "name");
                }
                catch (IOException iOException) {
                    this.logger.debug("Can't obtain label for group. Will use the default one");
                }
            }
            if (label == null || label.isEmpty()) {
                label = info.getName();
            }
            if (label == null || label.isEmpty()) {
                label = "Bose SoundTouch";
            }
            if (addrs.length > 1) {
                this.logger.warn("Bose SoundTouch device {} ({}) reports multiple addresses - using the first one: {}", new Object[]{info.getName(), label, Arrays.toString(addrs)});
            }
            properties.put("host", addrs[0].getHostAddress());
            if (this.getMacAddress(info) != null) {
                properties.put("macAddress", new String(this.getMacAddress(info)));
            }
            return DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(label).withTTL(600L).build();
        }
        return result;
    }

    public ThingUID getThingUID(ServiceInfo info) {
        this.logger.trace("ServiceInfo: {}", (Object)info);
        ThingTypeUID typeUID = this.getThingTypeUID(info);
        if (typeUID != null && info.getType() != null && info.getType().equals(this.getServiceType())) {
            this.logger.trace("Discovered a Bose SoundTouch thing with name '{}'", (Object)info.getName());
            byte[] mac = this.getMacAddress(info);
            if (mac != null) {
                return new ThingUID(typeUID, new String(mac));
            }
            return null;
        }
        return null;
    }

    public String getServiceType() {
        return "_soundtouch._tcp.local.";
    }

    private ThingTypeUID getThingTypeUID(ServiceInfo info) {
        InetAddress[] addrs = info.getInetAddresses();
        if (addrs.length > 0) {
            String deviceType;
            String ip = addrs[0].getHostAddress();
            String deviceId = null;
            byte[] mac = this.getMacAddress(info);
            if (mac != null) {
                deviceId = new String(mac);
            }
            try {
                String content = DiscoveryUtil.executeUrl("http://" + ip + ":8090/info");
                deviceType = DiscoveryUtil.getContentOfFirstElement(content, "type");
            }
            catch (IOException iOException) {
                return null;
            }
            if (deviceType.toLowerCase().contains("soundtouch 10")) {
                block15: {
                    try {
                        String group = DiscoveryUtil.executeUrl("http://" + ip + ":8090/getGroup");
                        String masterDevice = DiscoveryUtil.getContentOfFirstElement(group, "masterDeviceId");
                        if (Objects.equals(deviceId, masterDevice)) {
                            return BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID;
                        }
                        if (masterDevice.isEmpty()) break block15;
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                return BoseSoundTouchBindingConstants.BST_10_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("soundtouch 20")) {
                return BoseSoundTouchBindingConstants.BST_20_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("soundtouch 300")) {
                return BoseSoundTouchBindingConstants.BST_300_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("soundtouch 30")) {
                return BoseSoundTouchBindingConstants.BST_30_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("soundtouch wireless link adapter")) {
                return BoseSoundTouchBindingConstants.BST_WLA_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("wave")) {
                return BoseSoundTouchBindingConstants.BST_WSMS_THING_TYPE_UID;
            }
            if (deviceType.toLowerCase().contains("amplifier")) {
                return BoseSoundTouchBindingConstants.BST_SA5A_THING_TYPE_UID;
            }
            return null;
        }
        return null;
    }

    private byte[] getMacAddress(ServiceInfo info) {
        if (info != null) {
            if (!info.hasData()) {
                return null;
            }
            byte[] mac = info.getPropertyBytes("MAC");
            if (mac == null) {
                this.logger.warn("SoundTouch Device {} delivered no MAC address!", (Object)info.getName());
                return null;
            }
            if (mac.length != 12) {
                BigInteger bi = new BigInteger(1, mac);
                this.logger.warn("SoundTouch Device {} delivered an invalid MAC address: 0x{}", (Object)info.getName(), (Object)String.format("%0" + (mac.length << 1) + "X", bi));
                return null;
            }
            return mac;
        }
        return null;
    }
}

