/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.discovery.OwDiscoveryService;
import org.eclipse.smarthome.binding.onewire.internal.handler.CounterSensorThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.DigitalIOThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.IButtonThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.MultisensorThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwserverBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.TemperatureSensorThingHandler;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ThingHandlerFactory.class}, name="binding.onewire", configurationPid="binding.onewire", configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class OwHandlerFactory
extends BaseThingHandlerFactory {
    private final Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();
    @NonNullByDefault(value={})
    private OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return OwBindingConstants.SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (OwserverBridgeHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            OwserverBridgeHandler owserverBridgeHandler = new OwserverBridgeHandler((Bridge)thing);
            this.registerDiscoveryService(owserverBridgeHandler);
            return owserverBridgeHandler;
        }
        if (TemperatureSensorThingHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return new TemperatureSensorThingHandler(thing, this.dynamicStateDescriptionProvider);
        }
        if (IButtonThingHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return new IButtonThingHandler(thing, this.dynamicStateDescriptionProvider);
        }
        if (DigitalIOThingHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return new DigitalIOThingHandler(thing, this.dynamicStateDescriptionProvider);
        }
        if (MultisensorThingHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return new MultisensorThingHandler(thing, this.dynamicStateDescriptionProvider);
        }
        if (CounterSensorThingHandler.SUPPORTED_THING_TYPES.contains(thingTypeUID)) {
            return new CounterSensorThingHandler(thing, this.dynamicStateDescriptionProvider);
        }
        return null;
    }

    private synchronized void registerDiscoveryService(OwserverBridgeHandler owserverBridgeHandler) {
        OwDiscoveryService owDiscoveryService = new OwDiscoveryService(owserverBridgeHandler);
        this.discoveryServiceRegs.put(owserverBridgeHandler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)owDiscoveryService, new Hashtable()));
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (thingHandler instanceof OwserverBridgeHandler && (serviceReg = this.discoveryServiceRegs.remove(thingHandler.getThing().getUID())) != null) {
            OwDiscoveryService service = (OwDiscoveryService)((Object)this.bundleContext.getService(serviceReg.getReference()));
            serviceReg.unregister();
            if (service != null) {
                service.deactivate();
            }
        }
    }

    @Reference
    protected void setDynamicStateDescriptionProvider(OwDynamicStateDescriptionProvider provider) {
        this.dynamicStateDescriptionProvider = provider;
    }

    protected void unsetDynamicStateDescriptionProvider(OwDynamicStateDescriptionProvider provider) {
        this.dynamicStateDescriptionProvider = null;
    }
}

