/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS2423
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(DS2423.class);
    private static final OwDeviceParameterMap COUNTER_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/counters.ALL"));
        }
    };

    public DS2423(String sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() throws OwException {
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue()) {
            List<State> states = bridgeHandler.readDecimalTypeArray(this.sensorId, COUNTER_PARAMETER);
            this.logger.trace("read array {} from {}", states, (Object)this.sensorId);
            if (states.size() != 2) {
                throw new OwException("Expected exactly two values, got " + String.valueOf(states.size()));
            }
            this.callback.postUpdate("counter0", states.get(0));
            this.callback.postUpdate("counter1", states.get(1));
        }
    }
}

