/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.discovery;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DS2438Configuration;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OwDiscoveryItem {
    private final Logger logger = LoggerFactory.getLogger(OwDiscoveryItem.class);
    private final String familyId;
    private final String sensorId;
    private OwSensorType sensorType = OwSensorType.UNKNOWN;
    private String vendor = "Dallas/Maxim";
    private String hwRevision = "";
    private String prodDate = "";
    private OwPageBuffer pages = new OwPageBuffer();
    private ThingTypeUID thingTypeUID = new ThingTypeUID("onewire", "");
    private final List<String> associatedSensorIds = new ArrayList<String>();
    private final List<OwSensorType> associatedSensorTypes = new ArrayList<OwSensorType>();
    private final List<OwDiscoveryItem> associatedSensors = new ArrayList<OwDiscoveryItem>();

    public OwDiscoveryItem(OwBaseBridgeHandler bridgeHandler, String sensorId) throws OwException {
        this.sensorId = sensorId;
        this.familyId = sensorId.substring(0, 2);
        this.sensorType = bridgeHandler.getType(sensorId);
        switch (this.sensorType) {
            case DS2438: {
                this.pages = bridgeHandler.readPages(sensorId);
                DS2438Configuration config = new DS2438Configuration(this.pages);
                this.associatedSensorIds.addAll(config.getAssociatedSensorIds());
                this.logger.trace("found associated sensors: {}", this.associatedSensorIds);
                this.vendor = config.getVendor();
                this.hwRevision = config.getHardwareRevision();
                this.prodDate = config.getProductionDate();
                this.sensorType = config.getSensorSubType();
            }
        }
        if (!OwBindingConstants.THING_TYPE_MAP.containsKey((Object)this.sensorType)) {
            throw new OwException((Object)((Object)this.sensorType) + " cannot be mapped to thing type");
        }
        this.thingTypeUID = OwBindingConstants.THING_TYPE_MAP.get((Object)this.sensorType);
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public OwSensorType getSensorType() {
        return this.sensorType;
    }

    public String getSensorId() {
        return this.sensorId;
    }

    public String getNormalizedSensorId() {
        return this.sensorId.replace(".", "_");
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProductionDate() {
        return this.prodDate;
    }

    public String getHardwareRevision() {
        return this.hwRevision;
    }

    public ThingTypeUID getThingTypeUID() {
        return this.thingTypeUID;
    }

    public boolean hasAssociatedSensorIds() {
        return !this.associatedSensorIds.isEmpty();
    }

    public List<String> getAssociatedSensorIds() {
        return this.associatedSensorIds;
    }

    public boolean hasAssociatedSensors() {
        return !this.associatedSensors.isEmpty();
    }

    public void addAssociatedSensor(OwDiscoveryItem associatedSensor) {
        this.associatedSensors.add(associatedSensor);
        this.associatedSensorTypes.add(associatedSensor.getSensorType());
    }

    public void addAssociatedSensors(List<OwDiscoveryItem> associatedSensors) {
        for (OwDiscoveryItem associatedSensor : associatedSensors) {
            this.addAssociatedSensor(associatedSensor);
        }
    }

    public List<OwDiscoveryItem> getAssociatedSensors() {
        return this.associatedSensors;
    }

    public List<OwDiscoveryItem> getAssociatedSensors(OwSensorType sensorType) {
        ArrayList<OwDiscoveryItem> returnList = new ArrayList<OwDiscoveryItem>();
        for (OwDiscoveryItem owDiscoveryItem : this.associatedSensors) {
            if (sensorType != owDiscoveryItem.getSensorType()) continue;
            returnList.add(owDiscoveryItem);
        }
        return returnList;
    }

    public int getAssociatedSensorCount() {
        return this.associatedSensors.size() + 1;
    }

    public void clearAssociatedSensors() {
        this.associatedSensors.clear();
    }

    public void checkSensorType() {
        this.logger.debug("checkSensorType: {} with {}", (Object)this, this.associatedSensors);
        switch (this.sensorType) {
            case MS_TH: 
            case MS_TH_S: 
            case MS_TV: 
            case AMS: 
            case AMS_S: 
            case BMS: 
            case BMS_S: {
                this.sensorType = DS2438Configuration.getMultisensorType(this.sensorType, this.associatedSensorTypes);
            }
        }
        if (OwBindingConstants.THING_TYPE_MAP.containsKey((Object)this.sensorType)) {
            this.thingTypeUID = OwBindingConstants.THING_TYPE_MAP.get((Object)this.sensorType);
        }
    }

    public String getLabel() {
        return String.valueOf(OwBindingConstants.THING_LABEL_MAP.get(this.thingTypeUID)) + " (" + this.sensorId + ")";
    }

    public String toString() {
        return String.format("%s/%s (associated: %d)", new Object[]{this.sensorId, this.sensorType, this.associatedSensors.size()});
    }
}

