/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class OwBaseBridgeHandler
extends BaseBridgeHandler {
    private final Logger logger = LoggerFactory.getLogger(OwBaseBridgeHandler.class);
    protected boolean refreshable = false;
    protected ScheduledFuture<?> refreshTask = this.scheduler.scheduleWithFixedDelay(() -> this.refresh(), 1L, 1000L, TimeUnit.MILLISECONDS);

    public OwBaseBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    private void refresh() {
        if (this.isRefreshable()) {
            long now = System.currentTimeMillis();
            List thingList = this.getThing().getThings();
            int thingCount = thingList.size();
            this.logger.trace("called owRefresher at {}, {} childs", (Object)now, (Object)thingCount);
            for (Thing owThing : thingList) {
                this.logger.trace("getting handler for {} ({} to go)", (Object)owThing.getLabel(), (Object)thingCount);
                OwBaseThingHandler owHandler = (OwBaseThingHandler)owThing.getHandler();
                if (owHandler != null) {
                    if (owHandler.isRefreshable()) {
                        this.logger.trace("{} initialized, refreshing", (Object)owThing.getLabel());
                        owHandler.refresh(this, now);
                    } else {
                        this.logger.trace("{} not initialized, skipping refresh", (Object)owThing.getLabel());
                    }
                } else {
                    this.logger.debug("{} handler missing", (Object)owThing.getLabel());
                }
                --thingCount;
            }
        }
    }

    public void dispose() {
        this.refreshable = false;
        if (!this.refreshTask.isCancelled()) {
            this.refreshTask.cancel(false);
        }
    }

    public abstract List<String> getDirectory() throws OwException;

    public abstract State checkPresence(String var1) throws OwException;

    public abstract OwSensorType getType(String var1) throws OwException;

    public abstract OwPageBuffer readPages(String var1) throws OwException;

    public abstract State readDecimalType(String var1, OwDeviceParameterMap var2) throws OwException;

    public abstract List<State> readDecimalTypeArray(String var1, OwDeviceParameterMap var2) throws OwException;

    public abstract String readString(String var1, OwDeviceParameterMap var2) throws OwException;

    public abstract void writeDecimalType(String var1, OwDeviceParameterMap var2, DecimalType var3) throws OwException;

    public boolean isRefreshable() {
        return this.refreshable;
    }
}

