/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class OwBaseThingHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(OwBaseThingHandler.class);
    protected int sensorCount;
    protected final List<AbstractOwDevice> sensors = new ArrayList<AbstractOwDevice>();
    protected final List<String> sensorIds = new ArrayList<String>();
    protected long lastRefresh = 0L;
    protected long refreshInterval = 300000L;
    protected boolean validConfig = false;
    protected boolean showPresence = false;
    protected OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider;

    public OwBaseThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing);
        this.dynamicStateDescriptionProvider = dynamicStateDescriptionProvider;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.lastRefresh = 0L;
            this.logger.trace("scheduled {} for refresh", (Object)this.thing.getUID());
        }
    }

    public void initialize() {
        this.configure();
    }

    protected boolean configure() {
        Configuration configuration = this.getConfig();
        Map properties = this.thing.getProperties();
        if (this.getBridge() == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "bridge missing");
            return false;
        }
        this.sensorCount = Integer.valueOf((String)properties.get("sensorCount"));
        int i = 0;
        while (i < this.sensorCount) {
            String sensorId;
            String configKey;
            String string = configKey = i == 0 ? "id" : "id" + String.valueOf(i);
            if (configuration.get(configKey) != null) {
                sensorId = (String)configuration.get(configKey);
                if (!OwBindingConstants.SENSOR_ID_PATTERN.matcher(sensorId).matches()) {
                    this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "sensor id format mismatch");
                    return false;
                }
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "sensor id missing");
                return false;
            }
            this.sensorIds.add(sensorId);
            ++i;
        }
        this.refreshInterval = configuration.get("refresh") != null ? (long)(((BigDecimal)configuration.get("refresh")).intValue() * 1000) : 300000L;
        if (this.thing.getChannel("present") != null) {
            this.showPresence = true;
        }
        this.lastRefresh = 0L;
        return true;
    }

    public boolean isRefreshable() {
        return super.isInitialized() && this.thing.getStatusInfo().getStatusDetail() != ThingStatusDetail.CONFIGURATION_ERROR && this.thing.getStatusInfo().getStatusDetail() != ThingStatusDetail.BRIDGE_OFFLINE;
    }

    public void refresh(OwBaseBridgeHandler bridgeHandler, long now) {
        try {
            Boolean forcedRefresh = this.lastRefresh == 0L;
            if (now >= this.lastRefresh + this.refreshInterval) {
                this.logger.trace("refreshing {}", (Object)this.thing.getUID());
                this.lastRefresh = now;
                if (!this.sensors.get(0).checkPresence(bridgeHandler).booleanValue()) {
                    this.logger.trace("sensor not present");
                    return;
                }
                int i = 0;
                while (i < this.sensorCount) {
                    this.logger.trace("refreshing sensor {} ({})", (Object)i, (Object)this.sensors.get(i).getSensorId());
                    this.sensors.get(i).refresh(bridgeHandler, forcedRefresh);
                    ++i;
                }
            }
        }
        catch (OwException e) {
            this.logger.debug("{}: refresh exception {}", (Object)this.thing.getUID(), (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "refresh exception");
        }
    }

    public void updatePresenceStatus(State presentState) {
        if (OnOffType.ON.equals((Object)presentState)) {
            this.updateStatus(ThingStatus.ONLINE);
            if (this.showPresence) {
                this.updateState("present", (State)OnOffType.ON);
            }
        } else if (OnOffType.OFF.equals((Object)presentState)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "slave missing");
            if (this.showPresence) {
                this.updateState("present", (State)OnOffType.OFF);
            }
        } else {
            this.updateStatus(ThingStatus.UNKNOWN);
            if (this.showPresence) {
                this.updateState("present", (State)UnDefType.UNDEF);
            }
        }
    }

    public void postUpdate(String channelId, State state) {
        if (this.thing.getChannel(channelId) != null) {
            this.updateState(channelId, state);
        } else {
            this.logger.warn("{} missing channel {} when posting update {}", new Object[]{this.thing.getUID(), channelId, state});
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        if (bridgeStatusInfo.getStatus() == ThingStatus.ONLINE && this.getThing().getStatusInfo().getStatusDetail() == ThingStatusDetail.BRIDGE_OFFLINE) {
            if (this.validConfig) {
                this.updatePresenceStatus((State)UnDefType.UNDEF);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR);
            }
        } else if (bridgeStatusInfo.getStatus() == ThingStatus.OFFLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
        }
    }

    public void dispose() {
        this.dynamicStateDescriptionProvider.removeDescriptionsForThing(this.getThing().getUID());
        this.sensorIds.clear();
        this.sensors.clear();
        super.dispose();
    }

    protected void updateSensorProperties() {
        Map properties = this.editProperties();
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.logger.debug("updating thing properties failed, no bridge available");
            this.scheduler.schedule(() -> this.updateSensorProperties(), 5000L, TimeUnit.MILLISECONDS);
            return;
        }
        OwBaseBridgeHandler bridgeHandler = (OwBaseBridgeHandler)bridge.getHandler();
        try {
            if (bridgeHandler == null) {
                throw new OwException("no bridge handler available");
            }
            OwSensorType sensorType = bridgeHandler.getType(this.sensorIds.get(0));
            properties.put("modelId", sensorType.toString());
            properties.put("vendor", "Dallas/Maxim");
            this.logger.trace("updated modelid/vendor to {} / {}", (Object)sensorType.name(), (Object)"Dallas/Maxim");
        }
        catch (OwException e) {
            this.logger.info("updating thing properties failed: {}", (Object)e.getMessage());
            this.scheduler.schedule(() -> this.updateSensorProperties(), 5000L, TimeUnit.MILLISECONDS);
            return;
        }
        this.updateProperties(properties);
    }

    public @Nullable OwDynamicStateDescriptionProvider getDynamicStateDescriptionProvider() {
        return this.dynamicStateDescriptionProvider;
    }
}

