/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS18x20;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;

@NonNullByDefault
public class TemperatureSensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OwBindingConstants.THING_TYPE_TEMPERATURE);

    public TemperatureSensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider);
    }

    @Override
    public void initialize() {
        Map properties = this.editProperties();
        if (!super.configure()) {
            return;
        }
        if (this.getThing().getStatus() == ThingStatus.OFFLINE) {
            return;
        }
        this.sensors.add(new DS18x20((String)this.sensorIds.get(0), this));
        if (!properties.containsKey("modelId")) {
            this.scheduler.execute(() -> this.updateSensorProperties());
        } else {
            this.scheduler.execute(() -> this.configureThingChannels());
        }
    }

    private void configureThingChannels() {
        Channel tempChannel = this.thing.getChannel("temperature");
        if (tempChannel == null) {
            Map properties = this.editProperties();
            ThingBuilder thingBuilder = this.editThing();
            if (((String)properties.get("modelId")).equals("DS18B20") || ((String)properties.get("modelId")).equals("DS1822")) {
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES));
            } else {
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR));
            }
            this.updateThing(thingBuilder.build());
        }
        try {
            ((AbstractOwDevice)this.sensors.get(0)).configureChannels();
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("temperature");
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        this.updateStatus(ThingStatus.UNKNOWN, ThingStatusDetail.NONE);
    }
}

