/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.owserver;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public enum OwserverPressureScale {
    MILLIBAR(0),
    ATM(262144),
    MMHG(524288),
    INHG(786432),
    PSI(0x100000),
    PASCAL(0x140000);

    private static final int CLEAR_MASK = 0x1C0000;
    private final int flag;

    private OwserverPressureScale(int flag) {
        this.flag = flag;
    }

    public int getValue() {
        return this.flag;
    }

    public int setFlag(int flags) {
        return flags & 0xFFE3FFFF | this.getValue();
    }

    public static OwserverPressureScale getFlag(int flags) throws IllegalArgumentException {
        OwserverPressureScale[] owserverPressureScaleArray = OwserverPressureScale.values();
        int n = owserverPressureScaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            OwserverPressureScale value = owserverPressureScaleArray[n2];
            if (value.getValue() == (flags & 0x1C0000)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Pressure scale flag not found");
    }
}

