/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.discovery;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.AbstractOpenWeatherMapHandler;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.OpenWeatherMapAPIHandler;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.LocationProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OpenWeatherMapDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(OpenWeatherMapDiscoveryService.class);
    private static final int DISCOVERY_TIMEOUT_SECONDS = 2;
    private static final int DISCOVERY_INTERVAL_SECONDS = 60;
    private @Nullable ScheduledFuture<?> discoveryJob;
    private final LocationProvider locationProvider;
    private @Nullable PointType previousLocation;
    private final OpenWeatherMapAPIHandler bridgeHandler;

    public OpenWeatherMapDiscoveryService(OpenWeatherMapAPIHandler bridgeHandler, LocationProvider locationProvider, LocaleProvider localeProvider, TranslationProvider i18nProvider) {
        super(AbstractOpenWeatherMapHandler.SUPPORTED_THING_TYPES, 2);
        this.bridgeHandler = bridgeHandler;
        this.locationProvider = locationProvider;
        this.localeProvider = localeProvider;
        this.i18nProvider = i18nProvider;
        this.activate(null);
    }

    protected void activate(@Nullable Map<String, @Nullable Object> configProperties) {
        super.activate(configProperties);
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime(), this.bridgeHandler.getThing().getUID());
        super.deactivate();
    }

    protected void startScan() {
        this.logger.debug("Start manual OpenWeatherMap Location discovery scan.");
        this.scanForNewLocation();
    }

    protected synchronized void stopScan() {
        this.logger.debug("Stop manual OpenWeatherMap Location discovery scan.");
        super.stopScan();
    }

    protected void startBackgroundDiscovery() {
        if (this.discoveryJob == null || this.discoveryJob.isCancelled()) {
            this.logger.debug("Start OpenWeatherMap Location background discovery job at interval {} s.", (Object)60);
            this.discoveryJob = this.scheduler.scheduleWithFixedDelay(this::scanForNewLocation, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    protected void stopBackgroundDiscovery() {
        if (this.discoveryJob != null && !this.discoveryJob.isCancelled()) {
            this.logger.debug("Stop OpenWeatherMap Location background discovery job.");
            if (this.discoveryJob.cancel(true)) {
                this.discoveryJob = null;
            }
        }
    }

    private void scanForNewLocation() {
        PointType currentLocation = this.locationProvider.getLocation();
        if (currentLocation == null) {
            this.logger.debug("Location is not set -> Will not provide any discovery results.");
        } else if (!Objects.equals(currentLocation, this.previousLocation)) {
            this.logger.debug("Location has been changed from {} to {} -> Creating new discovery results.", (Object)this.previousLocation, (Object)currentLocation);
            this.createResults(currentLocation);
            this.previousLocation = currentLocation;
        } else {
            this.createResults(currentLocation);
        }
    }

    private void createResults(PointType location) {
        String locationString = location.toFullString();
        ThingUID bridgeUID = this.bridgeHandler.getThing().getUID();
        this.createWeatherAndForecastResult(locationString, bridgeUID);
    }

    private void createWeatherAndForecastResult(String location, ThingUID bridgeUID) {
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)new ThingUID(OpenWeatherMapBindingConstants.THING_TYPE_WEATHER_AND_FORECAST, bridgeUID, "local")).withLabel("Local weather and forecast").withProperty("location", (Object)location).withRepresentationProperty("location").withBridge(bridgeUID).build());
    }
}

