/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.binding.sonos.internal.handler.ZonePlayerHandler;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioHTTPServer;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.FixedLengthAudioStream;
import org.eclipse.smarthome.core.audio.URLAudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.util.ThingHandlerHelper;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonosAudioSink
implements AudioSink {
    private final Logger logger = LoggerFactory.getLogger(SonosAudioSink.class);
    private static final Set<AudioFormat> SUPPORTED_AUDIO_FORMATS = Collections.unmodifiableSet(Stream.of(AudioFormat.MP3, AudioFormat.WAV).collect(Collectors.toSet()));
    private static final Set<Class<? extends AudioStream>> SUPPORTED_AUDIO_STREAMS = Collections.unmodifiableSet(Stream.of(FixedLengthAudioStream.class, URLAudioStream.class).collect(Collectors.toSet()));
    private AudioHTTPServer audioHTTPServer;
    private ZonePlayerHandler handler;
    private String callbackUrl;

    public SonosAudioSink(ZonePlayerHandler handler, AudioHTTPServer audioHTTPServer, String callbackUrl) {
        this.handler = handler;
        this.audioHTTPServer = audioHTTPServer;
        this.callbackUrl = callbackUrl;
    }

    public String getId() {
        return this.handler.getThing().getUID().toString();
    }

    public String getLabel(Locale locale) {
        return this.handler.getThing().getLabel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        if (audioStream == null) {
            this.logger.trace("Stop currently playing stream.");
            this.handler.stopPlaying((Command)OnOffType.ON);
            return;
        } else if (audioStream instanceof URLAudioStream) {
            URLAudioStream urlAudioStream = (URLAudioStream)audioStream;
            this.handler.playURI((Command)new StringType(urlAudioStream.getURL()));
            try {
                audioStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        } else if (audioStream instanceof FixedLengthAudioStream) {
            if (this.callbackUrl != null) {
                String relativeUrl = this.audioHTTPServer.serve((FixedLengthAudioStream)audioStream, 10).toString();
                String url = String.valueOf(this.callbackUrl) + relativeUrl;
                AudioFormat format = audioStream.getFormat();
                if (!ThingHandlerHelper.isHandlerInitialized((ThingHandler)this.handler)) {
                    this.logger.warn("Sonos speaker '{}' is not initialized - status is {}", (Object)this.handler.getThing().getUID(), (Object)this.handler.getThing().getStatus());
                    return;
                } else if (AudioFormat.WAV.isCompatible(format)) {
                    this.handler.playNotificationSoundURI((Command)new StringType(String.valueOf(url) + "." + "wav"));
                    return;
                } else {
                    if (!AudioFormat.MP3.isCompatible(format)) throw new UnsupportedAudioFormatException("Sonos only supports MP3 or WAV.", format);
                    this.handler.playNotificationSoundURI((Command)new StringType(String.valueOf(url) + "." + "mp3"));
                }
                return;
            } else {
                this.logger.warn("We do not have any callback url, so Sonos cannot play the audio stream!");
            }
            return;
        } else {
            IOUtils.closeQuietly((InputStream)audioStream);
            throw new UnsupportedAudioStreamException("Sonos can only handle FixedLengthAudioStreams and URLAudioStreams.", audioStream.getClass());
        }
    }

    public Set<AudioFormat> getSupportedFormats() {
        return SUPPORTED_AUDIO_FORMATS;
    }

    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_AUDIO_STREAMS;
    }

    public PercentType getVolume() {
        String volume = this.handler.getVolume();
        return volume != null ? new PercentType(volume) : PercentType.ZERO;
    }

    public void setVolume(PercentType volume) {
        this.handler.setVolume((Command)volume);
    }
}

