/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.dispatch.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.config.dispatch.internal.ConfigDispatcher;
import org.eclipse.smarthome.core.service.AbstractWatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ConfigDispatcherFileWatcher
extends AbstractWatchService {
    public static final String SERVICEDIR_PROG_ARGUMENT = "smarthome.servicedir";
    public static final String SERVICES_FOLDER = "services";
    private ConfigDispatcher configDispatcher;

    public ConfigDispatcherFileWatcher() {
        super(ConfigDispatcherFileWatcher.getPathToWatch());
    }

    private static String getPathToWatch() {
        String progArg = System.getProperty(SERVICEDIR_PROG_ARGUMENT);
        if (progArg != null) {
            return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + progArg;
        }
        return String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + SERVICES_FOLDER;
    }

    @Activate
    public void activate() {
        super.activate();
        this.configDispatcher.processConfigFile(this.getSourcePath().toFile());
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    protected boolean watchSubDirectories() {
        return false;
    }

    protected WatchEvent.Kind<?>[] getWatchEventKinds(Path subDir) {
        return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }

    protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            File f = path.toFile();
            if (!f.isHidden() && f.getName().endsWith(".cfg")) {
                this.configDispatcher.processConfigFile(f);
            }
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            File configFile = path.toFile();
            if (configFile.isHidden() || configFile.isDirectory() || !configFile.getName().endsWith(".cfg")) {
                return;
            }
            this.configDispatcher.fileRemoved(configFile.getAbsolutePath());
        }
    }

    @Reference
    public void setConfigDispatcher(ConfigDispatcher configDispatcher) {
        this.configDispatcher = configDispatcher;
    }

    public void unsetConfigDispatcher(ConfigDispatcher configDispatcher) {
        this.configDispatcher = null;
    }
}

