/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import java.util.Map;
import org.eclipse.smarthome.config.xml.util.NodeName;

public class NodeAttributes
implements NodeName {
    private String nodeName;
    private Map<String, String> attributes;

    public NodeAttributes(String nodeName, Map<String, String> attributes) throws IllegalArgumentException {
        if (nodeName == null || nodeName.isEmpty()) {
            throw new IllegalArgumentException("The name of the node must neither be null nor empty!");
        }
        this.nodeName = nodeName;
        this.attributes = attributes;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "NodeAttributes [nodeName=" + this.nodeName + ", attributes=" + this.attributes + "]";
    }
}

