/**
 * Copyright (c) 2014,2018 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.core.scheduler.internal;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Extension of the default OSGi bundle activator
 *
 * @author Thomas.Eichstaedt-Engelen
 */
public final class SchedulerActivator implements BundleActivator {

    private final Logger logger = LoggerFactory.getLogger(SchedulerActivator.class);

    private static BundleContext context;

    /**
     * Called whenever the OSGi framework starts our bundle
     */
    @Override
    public void start(BundleContext bc) throws Exception {
        context = bc;
        logger.debug("Scheduler has been started.");

        try {
            StdSchedulerFactory.getDefaultScheduler().start();
        } catch (SchedulerException se) {
            logger.error("initializing scheduler throws exception", se);
        }
    }

    /**
     * Called whenever the OSGi framework stops our bundle
     */
    @Override
    public void stop(BundleContext bc) throws Exception {
        context = null;
        logger.debug("Scheduler has been stopped.");

        try {
            StdSchedulerFactory.getDefaultScheduler().shutdown();
        } catch (SchedulerException se) {
            logger.error("shutting down scheduler throws exception", se);
        }
    }

    /**
     * Returns the bundle context of this bundle
     * 
     * @return the bundle context
     */
    public static BundleContext getContext() {
        return context;
    }
}
