/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.semantics.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemPredicates;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataRegistry;
import org.eclipse.smarthome.core.semantics.SemanticTags;
import org.eclipse.smarthome.core.semantics.SemanticsPredicates;
import org.eclipse.smarthome.core.semantics.SemanticsService;
import org.eclipse.smarthome.core.semantics.model.Equipment;
import org.eclipse.smarthome.core.semantics.model.Location;
import org.eclipse.smarthome.core.semantics.model.Point;
import org.eclipse.smarthome.core.semantics.model.Tag;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component
public class SemanticsServiceImpl
implements SemanticsService {
    private static final String SYNONYMS_NAMESPACE = "synonyms";
    @NonNullByDefault(value={})
    private ItemRegistry itemRegistry;
    @NonNullByDefault(value={})
    private MetadataRegistry metadataRegistry;

    void activate(BundleContext context) {
    }

    @Reference
    void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    void setMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    void unsetMetadataRegistry(MetadataRegistry metadataRegistry) {
        this.metadataRegistry = null;
    }

    @Override
    public Set<Item> getItemsInLocation(Class<? extends Location> locationType) {
        HashSet<Item> items = new HashSet<Item>();
        Set locationItems = this.itemRegistry.stream().filter(SemanticsPredicates.isA(locationType)).collect(Collectors.toSet());
        for (Item locationItem : locationItems) {
            if (!(locationItem instanceof GroupItem)) continue;
            GroupItem gItem = (GroupItem)locationItem;
            items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
        }
        return items;
    }

    @Override
    public @NonNull Set<Item> getItemsInLocation(@NonNull String labelOrSynonym, Locale locale) {
        HashSet<Item> items = new HashSet<Item>();
        List<Class<? extends Tag>> tagList = SemanticTags.getByLabelOrSynonym(labelOrSynonym, locale);
        if (!tagList.isEmpty()) {
            for (Class<? extends Tag> tag : tagList) {
                if (!Location.class.isAssignableFrom(tag)) continue;
                items.addAll(this.getItemsInLocation(tag));
            }
        } else {
            Set locationItems = this.itemRegistry.stream().filter(ItemPredicates.hasLabel((String)labelOrSynonym).or(this.hasSynonym(labelOrSynonym)).and(SemanticsPredicates.isLocation())).collect(Collectors.toSet());
            for (Item locationItem : locationItems) {
                if (!(locationItem instanceof GroupItem)) continue;
                GroupItem gItem = (GroupItem)locationItem;
                items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
            }
        }
        return items;
    }

    private Predicate<? super Item> hasSynonym(String labelOrSynonym) {
        return item -> {
            MetadataKey key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName());
            Metadata md = (Metadata)this.metadataRegistry.get((Object)key);
            if (md != null) {
                String[] synonyms;
                String[] stringArray = synonyms = md.getValue().split(",");
                int n = synonyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    if (synonym.equalsIgnoreCase(labelOrSynonym)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        };
    }
}

