/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.AutoUpdatePolicy;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class ChannelBuilder {
    private final ChannelUID channelUID;
    private final @Nullable String acceptedItemType;
    private ChannelKind kind;
    private @Nullable Configuration configuration;
    private Set<String> defaultTags;
    private @Nullable Map<String, String> properties;
    private @Nullable String label;
    private @Nullable String description;
    private @Nullable ChannelTypeUID channelTypeUID;
    private @Nullable AutoUpdatePolicy autoUpdatePolicy;

    private ChannelBuilder(ChannelUID channelUID, @Nullable String acceptedItemType, Set<String> defaultTags) {
        this.channelUID = channelUID;
        this.acceptedItemType = acceptedItemType;
        this.defaultTags = defaultTags;
        this.kind = ChannelKind.STATE;
    }

    public static ChannelBuilder create(ChannelUID channelUID, @Nullable String acceptedItemType) {
        return new ChannelBuilder(channelUID, acceptedItemType, new HashSet<String>());
    }

    public static ChannelBuilder create(Channel channel) {
        String description;
        ChannelBuilder channelBuilder = ChannelBuilder.create(channel.getUID(), channel.getAcceptedItemType()).withConfiguration(channel.getConfiguration()).withDefaultTags(channel.getDefaultTags()).withKind(channel.getKind()).withProperties(channel.getProperties()).withType(channel.getChannelTypeUID());
        String label = channel.getLabel();
        if (label != null) {
            channelBuilder.withLabel(label);
        }
        if ((description = channel.getDescription()) != null) {
            channelBuilder.withDescription(description);
        }
        return channelBuilder;
    }

    public ChannelBuilder withType(@Nullable ChannelTypeUID channelTypeUID) {
        this.channelTypeUID = channelTypeUID;
        return this;
    }

    public ChannelBuilder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ChannelBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ChannelBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public ChannelBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ChannelBuilder withDefaultTags(Set<String> defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    public ChannelBuilder withKind(ChannelKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException("kind must not be null");
        }
        this.kind = kind;
        return this;
    }

    public ChannelBuilder withAutoUpdatePolicy(@Nullable AutoUpdatePolicy policy) {
        this.autoUpdatePolicy = policy;
        return this;
    }

    public Channel build() {
        return new Channel(this.channelUID, this.channelTypeUID, this.acceptedItemType, this.kind, this.configuration, this.defaultTags, this.properties, this.label, this.description, this.autoUpdatePolicy);
    }
}

