/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;

@NonNullByDefault
public final class FirmwareUpdateProgressInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareUpdateProgressInfoEvent.class.getSimpleName();
    private final FirmwareUpdateProgressInfo progressInfo;

    protected FirmwareUpdateProgressInfoEvent(String topic, String payload, FirmwareUpdateProgressInfo progressInfo) {
        super(topic, payload, null);
        this.progressInfo = progressInfo;
    }

    public FirmwareUpdateProgressInfo getProgressInfo() {
        return this.progressInfo;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.progressInfo == null ? 0 : this.progressInfo.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateProgressInfoEvent other = (FirmwareUpdateProgressInfoEvent)((Object)obj);
        return !(this.progressInfo == null ? other.progressInfo != null : !this.progressInfo.equals(other.progressInfo));
    }

    public String toString() {
        String stepName = this.progressInfo.getProgressStep() == null ? null : this.progressInfo.getProgressStep().name();
        return String.format("The firmware update progress for thing %s changed. Step: %s Progress: %d.", new Object[]{this.progressInfo.getThingUID(), stepName, this.progressInfo.getProgress()});
    }
}

