/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.cache;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ExpiringCacheAsync<V> {
    protected final long expiry;
    protected long expiresAt = 0L;
    protected @Nullable CompletableFuture<V> currentNewValueRequest = null;
    protected @Nullable V value;

    public ExpiringCacheAsync(Duration expiry) {
        if (expiry.isNegative() || expiry.isZero()) {
            throw new IllegalArgumentException("Cache expire time must be greater than 0");
        }
        this.expiry = expiry.toNanos();
    }

    public ExpiringCacheAsync(long expiry) {
        this(Duration.ofMillis(expiry));
    }

    public CompletableFuture<V> getValue(Supplier<CompletableFuture<V>> requestNewValueFuture) {
        if (this.isExpired()) {
            return this.refreshValue(requestNewValueFuture);
        }
        return CompletableFuture.completedFuture(this.value);
    }

    public void invalidateValue() {
        this.expiresAt = 0L;
    }

    protected long getCurrentNanoTime() {
        return System.nanoTime();
    }

    public synchronized CompletableFuture<V> refreshValue(Supplier<CompletableFuture<V>> requestNewValueFuture) {
        CompletableFuture<V> currentNewValueRequest = this.currentNewValueRequest;
        this.expiresAt = 0L;
        if (currentNewValueRequest != null) {
            return currentNewValueRequest;
        }
        this.currentNewValueRequest = requestNewValueFuture.get();
        currentNewValueRequest = this.currentNewValueRequest;
        if (currentNewValueRequest == null) {
            throw new IllegalArgumentException("We expect a CompletableFuture for refreshValue() to work!");
        }
        CompletionStage t = currentNewValueRequest.thenApply(newValue -> {
            this.currentNewValueRequest = null;
            this.value = newValue;
            this.expiresAt = this.getCurrentNanoTime() + this.expiry;
            return this.value;
        });
        if (t == null) {
            throw new IllegalArgumentException("We expect a CompletableFuture for refreshValue() to work!");
        }
        return t;
    }

    public boolean isExpired() {
        return this.expiresAt < this.getCurrentNanoTime();
    }

    public @Nullable V getLastKnownValue() {
        return this.value;
    }
}

