/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import java.util.List;
import javax.measure.Quantity;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.library.types.ArithmeticGroupFunction;
import org.eclipse.smarthome.core.library.types.DateTimeGroupFunction;
import org.eclipse.smarthome.core.library.types.QuantityTypeArithmeticGroupFunction;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.LoggerFactory;

public class GroupFunctionHelper {
    public GroupFunction createGroupFunction(GroupFunctionDTO function, List<State> args, @Nullable Class<? extends Quantity<?>> dimension) {
        if (dimension != null) {
            return this.createDimensionGroupFunction(function, args, dimension);
        }
        return this.createDefaultGroupFunction(function, args);
    }

    private GroupFunction createDimensionGroupFunction(GroupFunctionDTO function, List<State> args, @NonNull Class<? extends Quantity<?>> dimension) {
        String functionName = function.name;
        switch (functionName.toUpperCase()) {
            case "AVG": {
                return new QuantityTypeArithmeticGroupFunction.Avg(dimension);
            }
            case "SUM": {
                return new QuantityTypeArithmeticGroupFunction.Sum(dimension);
            }
            case "MIN": {
                return new QuantityTypeArithmeticGroupFunction.Min(dimension);
            }
            case "MAX": {
                return new QuantityTypeArithmeticGroupFunction.Max(dimension);
            }
        }
        return this.createDefaultGroupFunction(function, args);
    }

    private GroupFunction createDefaultGroupFunction(GroupFunctionDTO function, List<State> args) {
        String functionName = function.name;
        switch (functionName.toUpperCase()) {
            case "AND": {
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.And(args.get(0), args.get(1));
                }
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Group function 'AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "OR": {
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.Or(args.get(0), args.get(1));
                }
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Group function 'OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "NAND": {
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NAnd(args.get(0), args.get(1));
                }
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Group function 'NOT AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "NOR": {
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NOr(args.get(0), args.get(1));
                }
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Group function 'NOT OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "COUNT": {
                if (function.params != null && function.params.length == 1) {
                    StringType countParam = new StringType(function.params[0]);
                    return new ArithmeticGroupFunction.Count(countParam);
                }
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Group function 'COUNT' requires one argument. Using Equality instead.");
                break;
            }
            case "AVG": {
                return new ArithmeticGroupFunction.Avg();
            }
            case "SUM": {
                return new ArithmeticGroupFunction.Sum();
            }
            case "MIN": {
                return new ArithmeticGroupFunction.Min();
            }
            case "MAX": {
                return new ArithmeticGroupFunction.Max();
            }
            case "LATEST": {
                return new DateTimeGroupFunction.Latest();
            }
            case "EARLIEST": {
                return new DateTimeGroupFunction.Earliest();
            }
            case "EQUALITY": {
                return new GroupFunction.Equality();
            }
            default: {
                LoggerFactory.getLogger(GroupFunctionHelper.class).error("Unknown group function '{}'. Using Equality instead.", (Object)functionName);
            }
        }
        return new GroupFunction.Equality();
    }
}

