/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.internal.items.ItemBuilderImpl;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemBuilder;
import org.eclipse.smarthome.core.items.ItemBuilderFactory;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class ItemBuilderFactoryImpl
implements ItemBuilderFactory {
    @NonNullByDefault(value={})
    private final Set<ItemFactory> itemFactories = new CopyOnWriteArraySet<ItemFactory>();

    @Override
    public ItemBuilder newItemBuilder(Item item) {
        return new ItemBuilderImpl(this.itemFactories, item);
    }

    @Override
    public ItemBuilder newItemBuilder(String itemType, String itemName) {
        return new ItemBuilderImpl(this.itemFactories, itemType, itemName);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Reference(target="(component.name=org.eclipse.smarthome.core.library.CoreItemFactory)")
    protected void setCoreItemFactory(ItemFactory coreItemFactory) {
        this.itemFactories.add(coreItemFactory);
    }

    protected void unsetCoreItemFactory(ItemFactory coreItemFactory) {
        this.itemFactories.remove(coreItemFactory);
    }
}

