/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.items;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.UnitProvider;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemStateConverter;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.core.types.util.UnitUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ItemStateConverterImpl
implements ItemStateConverter {
    private final Logger logger = LoggerFactory.getLogger(ItemStateConverterImpl.class);
    private UnitProvider unitProvider;

    @Override
    public @NonNull State convertToAcceptedState(@Nullable State state, @Nullable Item item) {
        if (state == null) {
            this.logger.error("A conversion of null was requested:", (Throwable)new IllegalArgumentException("State must not be null."));
            return UnDefType.NULL;
        }
        if (item != null && !this.isAccepted(item, state)) {
            for (Class<? extends State> acceptedType : item.getAcceptedDataTypes()) {
                State convertedState = state.as(acceptedType);
                if (convertedState == null) continue;
                this.logger.debug("Converting {} '{}' to {} '{}' for item '{}'", new Object[]{state.getClass().getSimpleName(), state, convertedState.getClass().getSimpleName(), convertedState, item.getName()});
                return convertedState;
            }
        }
        if (item instanceof NumberItem && state instanceof QuantityType) {
            NumberItem numberItem = (NumberItem)item;
            if (numberItem.getDimension() != null) {
                QuantityType quantityState = (QuantityType)state;
                Unit<?> itemUnit = this.parseItemUnit(numberItem);
                if (itemUnit != null) {
                    if (!itemUnit.equals(quantityState.getUnit())) {
                        return this.convertOrUndef(quantityState, itemUnit);
                    }
                    return quantityState;
                }
                Class<? extends Quantity<?>> dimension = numberItem.getDimension();
                Unit<? extends Quantity<?>> conversionUnit = this.unitProvider.getUnit(dimension);
                if (conversionUnit != null && UnitUtils.isDifferentMeasurementSystem(conversionUnit, quantityState.getUnit())) {
                    return this.convertOrUndef(quantityState, conversionUnit);
                }
                return state;
            }
            DecimalType convertedState = state.as(DecimalType.class);
            if (convertedState != null) {
                return convertedState;
            }
        }
        return state;
    }

    private @NonNull State convertOrUndef(QuantityType<?> quantityState, Unit<?> targetUnit) {
        QuantityType<?> converted = quantityState.toUnit(targetUnit);
        if (converted != null) {
            return converted;
        }
        return UnDefType.UNDEF;
    }

    private Unit<?> parseItemUnit(NumberItem numberItem) {
        StateDescription stateDescription = numberItem.getStateDescription();
        if (stateDescription == null) {
            return null;
        }
        String pattern = stateDescription.getPattern();
        return UnitUtils.parseUnit(pattern);
    }

    private boolean isAccepted(Item item, State state) {
        return item.getAcceptedDataTypes().contains(state.getClass());
    }

    @Reference
    public void setUnitProvider(UnitProvider unitProvider) {
        this.unitProvider = unitProvider;
    }

    protected void unsetUnitProvider(UnitProvider unitProvider) {
        this.unitProvider = null;
    }
}

