/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class SwitchItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(OnOffType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(OnOffType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public SwitchItem(String name) {
        super("Switch", name);
    }

    SwitchItem(String type, String name) {
        super(type, name);
    }

    public void send(OnOffType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(acceptedDataTypes, state)) {
            super.setState(state);
        } else {
            this.logSetTypeError(state);
        }
    }
}

