/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.IllegalFormatConversionException;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.library.unit.UnitInitializer;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.function.QuantityFunctions;
import tec.uom.se.quantity.Quantities;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE, DefaultLocation.FIELD, DefaultLocation.TYPE_ARGUMENT})
public class QuantityType<T extends Quantity<T>>
extends Number
implements PrimitiveType,
State,
Command,
Comparable<QuantityType<T>> {
    private final Logger logger = LoggerFactory.getLogger(QuantityType.class);
    private static final long serialVersionUID = 8828949721938234629L;
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    public static final QuantityType<Dimensionless> ZERO = new QuantityType(0, AbstractUnit.ONE);
    public static final QuantityType<Dimensionless> ONE = new QuantityType(1, AbstractUnit.ONE);
    private static final String UNIT_PATTERN = "(?<=\\d)\\s*(?=[a-zA-Z\u00b0\u00b5%'](?![\\+\\-]?\\d))";
    private final Quantity<T> quantity;

    static {
        UnitInitializer.init();
    }

    public QuantityType() {
        this.quantity = QuantityType.ZERO.quantity;
    }

    public QuantityType(String value) {
        CharSequence[] constituents = value.split(UNIT_PATTERN);
        String formatted = String.join((CharSequence)" ", constituents);
        this.quantity = Quantities.getQuantity((CharSequence)formatted);
    }

    public QuantityType(Number value, Unit<T> unit) {
        BigDecimal bd = new BigDecimal(value.toString());
        this.quantity = Quantities.getQuantity((Number)bd, unit);
    }

    private QuantityType(Quantity<T> quantity) {
        this.quantity = quantity;
    }

    public static <T extends Quantity<T>> QuantityType<T> valueOf(double value, Unit<T> unit) {
        return new QuantityType<T>(value, unit);
    }

    public String toString() {
        return this.toFullString();
    }

    public static QuantityType<? extends Quantity<?>> valueOf(String value) {
        return new QuantityType(value);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuantityType)) {
            return false;
        }
        QuantityType other = (QuantityType)obj;
        if (!this.quantity.getUnit().getDimension().equals(other.quantity.getUnit().getDimension())) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(QuantityType<T> o) {
        if (this.quantity.getUnit().isCompatible(o.quantity.getUnit())) {
            QuantityType<T> v1 = this.toUnit(this.getUnit().getSystemUnit());
            QuantityType<T> v2 = o.toUnit(o.getUnit().getSystemUnit());
            if (v1 != null && v2 != null) {
                return Double.compare(v1.doubleValue(), v2.doubleValue());
            }
            throw new IllegalArgumentException("Unable to convert to system unit during compare.");
        }
        throw new IllegalArgumentException("Can not compare incompatible units.");
    }

    public Unit<T> getUnit() {
        return this.quantity.getUnit();
    }

    public Dimension getDimension() {
        return this.getUnit().getDimension();
    }

    public @Nullable QuantityType<T> toUnit(Unit<?> targetUnit) {
        if (!targetUnit.equals(this.getUnit())) {
            try {
                UnitConverter uc = this.getUnit().getConverterToAny(targetUnit);
                ComparableQuantity result = Quantities.getQuantity((Number)uc.convert(this.quantity.getValue()), targetUnit);
                return new QuantityType(result.getValue(), targetUnit);
            }
            catch (IncommensurableException | UnconvertibleException throwable) {
                this.logger.debug("Unable to convert unit from {} to {}", this.getUnit(), targetUnit);
                return null;
            }
        }
        return this;
    }

    public @Nullable QuantityType<T> toUnit(String targetUnit) {
        Unit unit = AbstractUnit.parse((CharSequence)targetUnit);
        if (unit != null) {
            return this.toUnit(unit);
        }
        return null;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.quantity.getValue().toString());
    }

    public int hashCode() {
        int tmp = 31 * this.getUnit().hashCode();
        return tmp += 31 * (this.quantity.getValue() == null ? 0 : this.quantity.getValue().hashCode());
    }

    @Override
    public String format(@Nullable String pattern) {
        String formatPattern = pattern;
        if (formatPattern != null && formatPattern.contains("%unit%")) {
            String unitSymbol = this.getUnit().equals(SmartHomeUnits.PERCENT) ? "%%" : this.getUnit().toString();
            formatPattern = formatPattern.replace("%unit%", unitSymbol);
        }
        try {
            return String.format(formatPattern, this.toBigDecimal().toBigIntegerExact());
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {}
        return String.format(formatPattern, this.toBigDecimal());
    }

    @Override
    public int intValue() {
        return this.quantity.getValue().intValue();
    }

    @Override
    public long longValue() {
        return this.quantity.getValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.quantity.getValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.quantity.getValue().doubleValue();
    }

    @Override
    public String toFullString() {
        if (this.quantity.getUnit() == AbstractUnit.ONE) {
            return this.quantity.getValue().toString();
        }
        return this.quantity.toString();
    }

    public <U extends State> @Nullable U as(@Nullable Class<U> target) {
        if (target == OnOffType.class) {
            if (this.intValue() == 0) {
                return (U)((State)target.cast(OnOffType.OFF));
            }
            if (SmartHomeUnits.PERCENT.equals(this.getUnit())) {
                return (U)((State)target.cast(this.toBigDecimal().compareTo(BigDecimal.ZERO) > 0 ? OnOffType.ON : OnOffType.OFF));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(OnOffType.ON));
            }
            return null;
        }
        if (target == UpDownType.class) {
            if (this.doubleValue() == 0.0) {
                return (U)((State)target.cast(UpDownType.UP));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(UpDownType.DOWN));
            }
            return null;
        }
        if (target == OpenClosedType.class) {
            if (this.doubleValue() == 0.0) {
                return (U)((State)target.cast(OpenClosedType.CLOSED));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (U)((State)target.cast(OpenClosedType.OPEN));
            }
            return null;
        }
        if (target == HSBType.class) {
            return (U)((State)target.cast(new HSBType(DecimalType.ZERO, PercentType.ZERO, new PercentType(this.toBigDecimal().multiply(HUNDRED)))));
        }
        if (target == PercentType.class) {
            if (SmartHomeUnits.PERCENT.equals(this.getUnit())) {
                return (U)((State)target.cast(new PercentType(this.toBigDecimal())));
            }
            return (U)((State)target.cast(new PercentType(this.toBigDecimal().multiply(HUNDRED))));
        }
        if (target == DecimalType.class) {
            return (U)((State)target.cast(new DecimalType(this.toBigDecimal())));
        }
        return State.super.as(target);
    }

    public QuantityType<T> add(QuantityType<T> state) {
        return new QuantityType<T>(this.quantity.add(state.quantity));
    }

    public QuantityType<T> negate() {
        return new QuantityType<T>(this.quantity.multiply((Number)-1));
    }

    public QuantityType<T> subtract(QuantityType<T> state) {
        return new QuantityType<T>(this.quantity.subtract(state.quantity));
    }

    public QuantityType<?> multiply(BigDecimal value) {
        return new QuantityType<T>(this.quantity.multiply((Number)value));
    }

    public QuantityType<?> multiply(QuantityType<?> state) {
        return new QuantityType<T>(this.quantity.multiply(state.quantity));
    }

    public QuantityType<?> divide(BigDecimal value) {
        return new QuantityType<T>(this.quantity.divide((Number)value));
    }

    public QuantityType<?> divide(QuantityType<?> state) {
        return new QuantityType<T>(this.quantity.divide(state.quantity));
    }

    public QuantityType<T> offset(QuantityType<T> offset, Unit<T> unit) {
        Quantity sum = (Quantity)Arrays.asList(this.quantity, offset.quantity).stream().reduce(QuantityFunctions.sum(unit)).get();
        return new QuantityType<T>(sum);
    }
}

