/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.smarthome.core.scheduler.AbstractExpression;
import org.eclipse.smarthome.core.scheduler.AbstractExpressionPart;

public class DateExpression
extends AbstractExpression<DateExpressionPart> {
    public DateExpression(String date) throws ParseException {
        this(date, Calendar.getInstance().getTime(), TimeZone.getDefault());
    }

    public DateExpression(String dateExpression, Date startTime, TimeZone zone) throws ParseException {
        super(dateExpression, "", startTime, zone, 0, 1);
    }

    @Override
    public boolean isSatisfiedBy(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && timeAfter.equals(originalDate);
    }

    public static boolean isValidExpression(String dateExpression) {
        try {
            new DateExpression(dateExpression);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    @Override
    protected void validateExpression() throws IllegalArgumentException {
    }

    @Override
    protected void populateWithSeeds() {
    }

    @Override
    protected DateExpressionPart parseToken(String token, int position) throws ParseException {
        return new DateExpressionPart(token);
    }

    @Override
    public boolean hasFloatingStartDate() {
        return false;
    }

    protected class DateExpressionPart
    extends AbstractExpressionPart {
        private Date theDate;

        public DateExpressionPart(String s) throws ParseException {
            super(s);
        }

        public Date getDate() {
            return this.theDate;
        }

        @Override
        public void parse() throws ParseException {
            if (!this.parseFormats(new String[]{"yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ssXX", "yyyy-MM-dd'T'HH:mm:ssXXX"})) {
                throw new ParseException(String.valueOf(this.getPart()) + " is not an ISO8601 formatted date", 0);
            }
        }

        private boolean parseFormats(String[] formats) {
            String[] stringArray = formats;
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                String format = stringArray[n2];
                try {
                    SimpleDateFormat df = new SimpleDateFormat(format);
                    df.setTimeZone(DateExpression.this.getTimeZone());
                    this.theDate = df.parse(DateExpression.this.getExpression());
                    return true;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
            return false;
        }

        @Override
        public List<Date> apply(Date startDate, List<Date> candidates) {
            candidates.add(this.theDate);
            return candidates;
        }

        @Override
        AbstractExpressionPart.BoundedIntegerSet initializeValueSet() {
            return null;
        }

        @Override
        public int order() {
            return 1;
        }
    }
}

