/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.eclipse.smarthome.core.scheduler.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionThreadPoolManager
extends ThreadPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionThreadPoolManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionThreadPoolExecutor getExpressionScheduledPool(String poolName) {
        ExecutorService pool = (ExecutorService)pools.get(poolName);
        if (pool == null) {
            Map map = pools;
            synchronized (map) {
                pool = (ExecutorService)pools.get(poolName);
                if (pool == null) {
                    Integer cfg = ExpressionThreadPoolManager.getConfig(poolName);
                    pool = new ExpressionThreadPoolExecutor(poolName, cfg);
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    pools.put(poolName, pool);
                    logger.debug("Created an expression-drive scheduled thread pool '{}' of size {}", (Object)poolName, (Object)cfg);
                }
            }
        }
        if (pool instanceof ExpressionThreadPoolExecutor) {
            return (ExpressionThreadPoolExecutor)pool;
        }
        throw new IllegalArgumentException("Pool " + poolName + " is not an expression-driven scheduled pool!");
    }

    public static class ExpressionThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private final Map<Expression, RunnableWrapper> scheduled = new ConcurrentHashMap<Expression, RunnableWrapper>();
        private final Map<RunnableWrapper, List<ScheduledFuture<?>>> futures = Collections.synchronizedMap(new HashMap());
        private final Lock futuresLock = new ReentrantLock();
        private final Map<Future<?>, Date> timestamps = Collections.synchronizedMap(new HashMap());
        private volatile Thread monitor;
        private final ThreadPoolManager.NamedThreadFactory monitorThreadFactory;
        private final Lock monitoringLock = new ReentrantLock();
        private final Condition newExpressionCondition = this.monitoringLock.newCondition();
        Runnable monitorTask = new Runnable(){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            @Override
            public void run() {
                ExpressionThreadPoolManager.access$0().debug("Starting the monitor thread '{}'", (Object)Thread.currentThread().getName());
                while (true) {
                    try {
                        block14: while (true) lbl-1000:
                        // 4 sources

                        {
                            earliestExecution = null;
                            now = new Date();
                            finishedExpressions = new ArrayList<Expression>();
                            if (ExpressionThreadPoolManager.access$0().isTraceEnabled()) {
                                ExpressionThreadPoolManager.access$0().trace("There are {} scheduled expressions", (Object)ExpressionThreadPoolExecutor.access$0(this).keySet().size());
                                for (Map.Entry entry : ExpressionThreadPoolExecutor.access$0(this).entrySet()) {
                                    ExpressionThreadPoolManager.access$0().trace("  Runnable {} with {}", entry.getValue(), entry.getValue());
                                }
                            }
                            for (Expression e : ExpressionThreadPoolExecutor.access$0(this).keySet()) {
                                time = e.getTimeAfter(now);
                                if (time != null) {
                                    ExpressionThreadPoolManager.access$0().trace("Expression's '{}' next execution time is {}", (Object)e, (Object)time);
                                    task = (RunnableWrapper)ExpressionThreadPoolExecutor.access$0(this).get(e);
                                    if (task != null) {
                                        try {
                                            ExpressionThreadPoolExecutor.access$1(this).lock();
                                            taskFutures = (ArrayList<ScheduledFuture<?>>)ExpressionThreadPoolExecutor.access$2(this).get(task);
                                            if (taskFutures == null) {
                                                taskFutures = new ArrayList<ScheduledFuture<?>>();
                                                ExpressionThreadPoolExecutor.access$2(this).put(task, taskFutures);
                                            }
                                            schedule = false;
                                            delay = time.getTime() - now.getTime();
                                            if (taskFutures.size() == 0) {
                                                schedule = true;
                                            } else {
                                                timestamp = (Date)ExpressionThreadPoolExecutor.access$3(this).get(taskFutures.get(taskFutures.size() - 1));
                                                if (time.after(timestamp)) {
                                                    schedule = true;
                                                } else {
                                                    ExpressionThreadPoolManager.access$0().trace("The task '{}' is already scheduled to execute in {} ms", (Object)task, (Object)delay);
                                                }
                                            }
                                            if (schedule) {
                                                ExpressionThreadPoolManager.access$0().debug("Scheduling the task '{}' to execute in {} ms", (Object)task, (Object)delay);
                                                newFuture = this.schedule(task, delay, TimeUnit.MILLISECONDS);
                                                taskFutures.add(newFuture);
                                                ExpressionThreadPoolManager.access$0().trace("Task '{}' has now {} Futures", (Object)task, (Object)taskFutures.size());
                                                ExpressionThreadPoolExecutor.access$3(this).put(newFuture, time);
                                            }
                                            if (!ExpressionThreadPoolManager.access$0().isTraceEnabled()) ** GOTO lbl53
                                            for (ScheduledFuture future : taskFutures) {
                                                ExpressionThreadPoolManager.access$0().trace("Task {} ({}) will run in {}", new Object[]{task, System.identityHashCode(task), future.getDelay(TimeUnit.MILLISECONDS)});
                                            }
                                        }
                                        finally {
                                            ExpressionThreadPoolExecutor.access$1(this).unlock();
                                        }
                                    } else {
                                        ExpressionThreadPoolManager.access$0().trace("Expressions without tasks are not valid");
                                    }
lbl53:
                                    // 3 sources

                                    if (earliestExecution == null) {
                                        earliestExecution = time;
                                        continue;
                                    }
                                    if (!time.before(earliestExecution)) continue;
                                    earliestExecution = time;
                                    continue;
                                }
                                ExpressionThreadPoolManager.access$0().debug("Expression '{}' has no future executions anymore", (Object)e);
                                finishedExpressions.add(e);
                            }
                            for (Expression e : finishedExpressions) {
                                ExpressionThreadPoolExecutor.access$0(this).remove(e);
                                ExpressionThreadPoolManager.access$0().trace("Cleaning up finished expression '{}'", (Object)e);
                            }
                            if (earliestExecution != null) {
                                newExpression = false;
                                while (true) {
                                    if (newExpression || !new Date().before(earliestExecution)) continue block14;
                                    if (ExpressionThreadPoolManager.access$0().isTraceEnabled()) {
                                        ExpressionThreadPoolManager.access$0().trace("Putting the monitor thread '{}' to sleep for {} ms", (Object)Thread.currentThread().getName(), (Object)(earliestExecution.getTime() - new Date().getTime()));
                                    }
                                    ExpressionThreadPoolExecutor.access$4(this).lock();
                                    newExpression = ExpressionThreadPoolExecutor.access$5(this).await(earliestExecution.getTime() - new Date().getTime(), TimeUnit.MILLISECONDS);
                                    ExpressionThreadPoolManager.access$0().trace("Monitor thread woke again with {}", (Object)newExpression);
                                    continue;
                                    break;
                                }
                                finally {
                                    ExpressionThreadPoolExecutor.access$4(this).unlock();
                                }
                            }
                            ExpressionThreadPoolManager.access$0().trace("Putting the monitor thread '{}' to sleep for {} ms", (Object)Thread.currentThread().getName(), (Object)60000L);
                            try {
                                ExpressionThreadPoolExecutor.access$4(this).lock();
                                ExpressionThreadPoolExecutor.access$5(this).await(60000L, TimeUnit.MILLISECONDS);
                            }
                            finally {
                                ExpressionThreadPoolExecutor.access$4(this).unlock();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (RejectedExecutionException ex) {
                        ExpressionThreadPoolManager.access$0().error("The executor has already been shut down : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    catch (CancellationException ex) {
                        ExpressionThreadPoolManager.access$0().error("Non executed tasks are cancelled : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ExpressionThreadPoolManager.access$0().trace("The monitor thread was interrupted : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
        };

        public ExpressionThreadPoolExecutor(final String poolName, int corePoolSize) {
            this(poolName, corePoolSize, new ThreadPoolManager.NamedThreadFactory(poolName), new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    logger.debug("Thread pool '{}' rejected execution of {}", (Object)poolName, runnable.getClass());
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        public ExpressionThreadPoolExecutor(String threadPool, int corePoolSize, ThreadPoolManager.NamedThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
            super(corePoolSize, threadFactory, rejectedHandler);
            this.monitorThreadFactory = new ThreadPoolManager.NamedThreadFactory(String.valueOf(threadFactory.getName()) + "-" + "Monitor");
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            Throwable cause;
            logger.trace("Cleaning up after the execution of '{}'", (Object)runnable);
            super.afterExecute(runnable, throwable);
            if (runnable instanceof Future) {
                Future future = (Future)((Object)runnable);
                try {
                    this.futuresLock.lock();
                    for (Runnable runnable2 : this.futures.keySet()) {
                        this.futures.get(runnable2).removeIf(entry -> entry == future);
                    }
                }
                finally {
                    this.futuresLock.unlock();
                }
                this.timestamps.remove(future);
            } else {
                ArrayList obsoleteFutures = new ArrayList();
                try {
                    this.futuresLock.lock();
                    List<ScheduledFuture<?>> list = this.futures.get(runnable);
                    if (list != null) {
                        logger.trace("Runnable '{}' has {} Futures scheduled", (Object)runnable, (Object)list.size());
                        for (Future<Object> future : list) {
                            if (!future.isDone()) continue;
                            obsoleteFutures.add((ScheduledFuture<?>)future);
                        }
                        logger.trace("Runnable '{}' has {} Futures that will be removed", (Object)runnable, (Object)obsoleteFutures.size());
                        for (Future<Object> future : obsoleteFutures) {
                            list.remove(future);
                            this.timestamps.remove(future);
                        }
                    } else {
                        logger.debug("Runnable '{}' has no Futures scheduled", (Object)runnable);
                    }
                }
                finally {
                    this.futuresLock.unlock();
                }
            }
            if (throwable != null && (cause = throwable.getCause()) instanceof InterruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Runnable task, Expression expression) {
            if (task == null || expression == null) {
                throw new IllegalArgumentException("Task cannot be scheduled as task or expression is null.");
            }
            RunnableWrapper wrapper = new RunnableWrapper(task);
            ExpressionThreadPoolExecutor expressionThreadPoolExecutor = this;
            synchronized (expressionThreadPoolExecutor) {
                if (this.monitor == null) {
                    this.monitor = this.monitorThreadFactory.newThread(this.monitorTask);
                    this.monitor.start();
                }
            }
            if (logger.isDebugEnabled() && this.scheduled.containsValue(wrapper)) {
                logger.debug("Task {} is already scheduled (potentially with a different expression).", (Object)wrapper);
            }
            this.scheduled.put(expression, wrapper);
            logger.debug("Scheduled task '{}' using expression '{}'", (Object)wrapper, (Object)expression);
            try {
                this.monitoringLock.lock();
                this.newExpressionCondition.signalAll();
            }
            finally {
                this.monitoringLock.unlock();
            }
        }

        public boolean remove(Expression expression) {
            logger.debug("Removing the expression '{}' from the scheduler", (Object)expression);
            RunnableWrapper task = this.scheduled.remove(expression);
            if (task != null) {
                return this.doRemoveFutures(task);
            }
            return false;
        }

        @Override
        public boolean remove(Runnable task) {
            RunnableWrapper wrapper = new RunnableWrapper(task);
            Expression theExpression = null;
            for (Expression anExpression : this.scheduled.keySet()) {
                if (!wrapper.equals(this.scheduled.get(anExpression))) continue;
                theExpression = anExpression;
                break;
            }
            if (theExpression != null) {
                return this.remove(theExpression);
            }
            return super.remove(task);
        }

        public boolean removeFutures(Runnable task) {
            RunnableWrapper wrapper = new RunnableWrapper(task);
            return this.doRemoveFutures(wrapper);
        }

        private boolean doRemoveFutures(RunnableWrapper task) {
            logger.trace("Removing Runnable '{}' from the scheduler", (Object)task);
            ArrayList<Future> obsoleteFutures = new ArrayList<Future>();
            try {
                this.futuresLock.lock();
                List<ScheduledFuture<?>> taskFutures = this.futures.get(task);
                if (taskFutures != null) {
                    if (taskFutures.size() != 0) {
                        logger.trace("Runnable '{}' has {} Futures to be removed", (Object)task, (Object)taskFutures.size());
                        for (Future future : taskFutures) {
                            future.cancel(false);
                            this.timestamps.remove(future);
                            obsoleteFutures.add(future);
                        }
                    }
                    for (Future future : obsoleteFutures) {
                        taskFutures.remove(future);
                    }
                    super.purge();
                    if (taskFutures.size() == 0) {
                        this.futures.remove(task);
                        return true;
                    }
                }
                return false;
            }
            finally {
                this.futuresLock.unlock();
            }
        }

        static /* synthetic */ Map access$0(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.scheduled;
        }

        static /* synthetic */ Lock access$1(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.futuresLock;
        }

        static /* synthetic */ Map access$2(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.futures;
        }

        static /* synthetic */ Map access$3(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.timestamps;
        }

        static /* synthetic */ Lock access$4(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.monitoringLock;
        }

        static /* synthetic */ Condition access$5(ExpressionThreadPoolExecutor expressionThreadPoolExecutor) {
            return expressionThreadPoolExecutor.newExpressionCondition;
        }
    }
}

