/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.http.auth.internal;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.core.auth.Authentication;
import org.eclipse.smarthome.io.http.Handler;
import org.eclipse.smarthome.io.http.HandlerContext;
import org.osgi.service.component.annotations.Component;

@Component
public class RedirectHandler
implements Handler {
    public int getPriority() {
        return 110;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
        Optional<Authentication> authhentication = Optional.ofNullable(request.getAttribute(Authentication.class.getName())).filter(Authentication.class::isInstance).map(Authentication.class::cast);
        Optional<String> redirect = Optional.ofNullable(request.getParameter("redirect"));
        if (authhentication.isPresent() && redirect.isPresent()) {
            response.setHeader("Location", redirect.get());
        }
        context.execute(request, response);
    }

    public void handleError(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
        context.execute(request, response);
    }
}

