/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Image;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class ImageRenderer
extends AbstractWidgetRenderer {
    private static final String URL_NONE_ICON = "images/none.png";

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Image;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        boolean ignoreRefresh;
        String url;
        Image image = (Image)w;
        String snippet = image.getChildren().size() > 0 ? this.getSnippet("image_link") : this.getSnippet("image");
        snippet = image.getRefresh() > 0 ? StringUtils.replace((String)snippet, (String)"%update_interval%", (String)Integer.toString(image.getRefresh())) : StringUtils.replace((String)snippet, (String)"%update_interval%", (String)"0");
        String widgetId = this.itemUIRegistry.getWidgetId(w);
        snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)widgetId);
        snippet = this.preprocessSnippet(snippet, w);
        String sitemap = null;
        if (w.eResource() != null) {
            sitemap = w.eResource().getURI().path();
        }
        boolean validUrl = this.isValidURL(image.getUrl());
        String proxiedUrl = "../proxy?sitemap=" + sitemap + "&amp;widgetId=" + widgetId;
        State state = this.itemUIRegistry.getState(w);
        if (!this.itemUIRegistry.getVisiblity(w)) {
            url = URL_NONE_ICON;
            ignoreRefresh = true;
        } else if (state instanceof RawType) {
            url = state.toFullString();
            ignoreRefresh = true;
        } else if (sitemap != null && (state instanceof StringType || validUrl)) {
            url = String.valueOf(proxiedUrl) + "&amp;t=" + new Date().getTime();
            ignoreRefresh = false;
        } else {
            url = URL_NONE_ICON;
            ignoreRefresh = true;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valid_url%", (String)(validUrl ? "true" : "false"));
        snippet = StringUtils.replace((String)snippet, (String)"%proxied_url%", (String)proxiedUrl);
        snippet = StringUtils.replace((String)snippet, (String)"%ignore_refresh%", (String)(ignoreRefresh ? "true" : "false"));
        snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

