/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scriptengine;

import org.eclipse.smarthome.core.scriptengine.Script;
import org.eclipse.smarthome.core.scriptengine.ScriptExecutionException;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutionThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecutionThread.class);
    private Script script;
    private IEvaluationContext context;
    private Object result = null;

    public ScriptExecutionThread(String name, Script script, IEvaluationContext context) {
        this.setName(name);
        this.script = script;
        this.context = context;
    }

    @Override
    public void run() {
        super.run();
        try {
            this.result = this.script.execute(this.context);
        }
        catch (ScriptExecutionException e) {
            String msg = e.getCause().getMessage();
            if (msg == null) {
                logger.error("Error during the execution of rule '{}'", (Object)this.getName(), (Object)e.getCause());
            }
            logger.error("Error during the execution of rule '{}': {}", new Object[]{this.getName(), msg});
        }
    }

    public Object getResult() {
        return this.result;
    }
}

