/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal;

import org.eclipse.smarthome.core.scriptengine.ScriptEngine;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.rule.RulesStandaloneSetup;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleRuntimeActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(RuleRuntimeActivator.class);
    public static ServiceTracker<ModelRepository, ModelRepository> modelRepositoryTracker;
    public static ServiceTracker<ScriptEngine, ScriptEngine> scriptEngineTracker;

    public void start(BundleContext bc) throws Exception {
        RulesStandaloneSetup.doSetup();
        logger.debug("Registered 'rule' configuration parser");
        modelRepositoryTracker = new ServiceTracker(bc, ModelRepository.class, null);
        modelRepositoryTracker.open();
        scriptEngineTracker = new ServiceTracker(bc, ScriptEngine.class, null);
        scriptEngineTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        modelRepositoryTracker.close();
        scriptEngineTracker.close();
    }
}

