/**
 */
package org.eclipse.smarthome.model.thing.thing.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelPropertyContainer;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingFactory;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.smarthome.model.thing.thing.ThingPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ThingPackageImpl extends EPackageImpl implements ThingPackage
{
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass thingModelEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass modelPropertyContainerEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass modelThingEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass modelChannelEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass modelPropertyEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass modelBridgeEClass = null;

  /**
   * Creates an instance of the model <b>Package</b>, registered with
   * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
   * package URI value.
   * <p>Note: the correct way to create the package is via the static
   * factory method {@link #init init()}, which also performs
   * initialization of the package, or returns the registered package,
   * if one already exists.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.EPackage.Registry
   * @see org.eclipse.smarthome.model.thing.thing.ThingPackage#eNS_URI
   * @see #init()
   * @generated
   */
  private ThingPackageImpl()
  {
    super(eNS_URI, ThingFactory.eINSTANCE);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static boolean isInited = false;

  /**
   * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
   * 
   * <p>This method is used to initialize {@link ThingPackage#eINSTANCE} when that field is accessed.
   * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #eNS_URI
   * @see #createPackageContents()
   * @see #initializePackageContents()
   * @generated
   */
  public static ThingPackage init()
  {
    if (isInited) return (ThingPackage)EPackage.Registry.INSTANCE.getEPackage(ThingPackage.eNS_URI);

    // Obtain or create and register package
    ThingPackageImpl theThingPackage = (ThingPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof ThingPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ThingPackageImpl());

    isInited = true;

    // Create package meta-data objects
    theThingPackage.createPackageContents();

    // Initialize created meta-data
    theThingPackage.initializePackageContents();

    // Mark meta-data to indicate it can't be changed
    theThingPackage.freeze();

  
    // Update the registry and return the package
    EPackage.Registry.INSTANCE.put(ThingPackage.eNS_URI, theThingPackage);
    return theThingPackage;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getThingModel()
  {
    return thingModelEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getThingModel_Things()
  {
    return (EReference)thingModelEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getModelPropertyContainer()
  {
    return modelPropertyContainerEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelPropertyContainer_Id()
  {
    return (EAttribute)modelPropertyContainerEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getModelPropertyContainer_Properties()
  {
    return (EReference)modelPropertyContainerEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getModelThing()
  {
    return modelThingEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelThing_ThingTypeId()
  {
    return (EAttribute)modelThingEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelThing_ThingId()
  {
    return (EAttribute)modelThingEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getModelThing_Channels()
  {
    return (EReference)modelThingEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getModelChannel()
  {
    return modelChannelEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelChannel_Type()
  {
    return (EAttribute)modelChannelEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getModelProperty()
  {
    return modelPropertyEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelProperty_Key()
  {
    return (EAttribute)modelPropertyEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelProperty_Value()
  {
    return (EAttribute)modelPropertyEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getModelBridge()
  {
    return modelBridgeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getModelBridge_Bridge()
  {
    return (EAttribute)modelBridgeEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getModelBridge_Things()
  {
    return (EReference)modelBridgeEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ThingFactory getThingFactory()
  {
    return (ThingFactory)getEFactoryInstance();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isCreated = false;

  /**
   * Creates the meta-model objects for the package.  This method is
   * guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void createPackageContents()
  {
    if (isCreated) return;
    isCreated = true;

    // Create classes and their features
    thingModelEClass = createEClass(THING_MODEL);
    createEReference(thingModelEClass, THING_MODEL__THINGS);

    modelPropertyContainerEClass = createEClass(MODEL_PROPERTY_CONTAINER);
    createEAttribute(modelPropertyContainerEClass, MODEL_PROPERTY_CONTAINER__ID);
    createEReference(modelPropertyContainerEClass, MODEL_PROPERTY_CONTAINER__PROPERTIES);

    modelThingEClass = createEClass(MODEL_THING);
    createEAttribute(modelThingEClass, MODEL_THING__THING_TYPE_ID);
    createEAttribute(modelThingEClass, MODEL_THING__THING_ID);
    createEReference(modelThingEClass, MODEL_THING__CHANNELS);

    modelChannelEClass = createEClass(MODEL_CHANNEL);
    createEAttribute(modelChannelEClass, MODEL_CHANNEL__TYPE);

    modelPropertyEClass = createEClass(MODEL_PROPERTY);
    createEAttribute(modelPropertyEClass, MODEL_PROPERTY__KEY);
    createEAttribute(modelPropertyEClass, MODEL_PROPERTY__VALUE);

    modelBridgeEClass = createEClass(MODEL_BRIDGE);
    createEAttribute(modelBridgeEClass, MODEL_BRIDGE__BRIDGE);
    createEReference(modelBridgeEClass, MODEL_BRIDGE__THINGS);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isInitialized = false;

  /**
   * Complete the initialization of the package and its meta-model.  This
   * method is guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void initializePackageContents()
  {
    if (isInitialized) return;
    isInitialized = true;

    // Initialize package
    setName(eNAME);
    setNsPrefix(eNS_PREFIX);
    setNsURI(eNS_URI);

    // Create type parameters

    // Set bounds for type parameters

    // Add supertypes to classes
    modelThingEClass.getESuperTypes().add(this.getModelPropertyContainer());
    modelChannelEClass.getESuperTypes().add(this.getModelPropertyContainer());
    modelBridgeEClass.getESuperTypes().add(this.getModelThing());

    // Initialize classes and features; add operations and parameters
    initEClass(thingModelEClass, ThingModel.class, "ThingModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getThingModel_Things(), this.getModelThing(), null, "things", null, 0, -1, ThingModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(modelPropertyContainerEClass, ModelPropertyContainer.class, "ModelPropertyContainer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getModelPropertyContainer_Id(), ecorePackage.getEString(), "id", null, 0, 1, ModelPropertyContainer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getModelPropertyContainer_Properties(), this.getModelProperty(), null, "properties", null, 0, -1, ModelPropertyContainer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(modelThingEClass, ModelThing.class, "ModelThing", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getModelThing_ThingTypeId(), ecorePackage.getEString(), "thingTypeId", null, 0, 1, ModelThing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getModelThing_ThingId(), ecorePackage.getEString(), "thingId", null, 0, 1, ModelThing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getModelThing_Channels(), this.getModelChannel(), null, "channels", null, 0, -1, ModelThing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(modelChannelEClass, ModelChannel.class, "ModelChannel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getModelChannel_Type(), ecorePackage.getEString(), "type", null, 0, 1, ModelChannel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(modelPropertyEClass, ModelProperty.class, "ModelProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getModelProperty_Key(), ecorePackage.getEString(), "key", null, 0, 1, ModelProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getModelProperty_Value(), ecorePackage.getEJavaObject(), "value", null, 0, 1, ModelProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(modelBridgeEClass, ModelBridge.class, "ModelBridge", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getModelBridge_Bridge(), ecorePackage.getEBoolean(), "bridge", null, 0, 1, ModelBridge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getModelBridge_Things(), this.getModelThing(), null, "things", null, 0, -1, ModelBridge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    // Create resource
    createResource(eNS_URI);
  }

} //ThingPackageImpl
