/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;

public class RuleTemplate
implements Template {
    private String uid;
    private List<Trigger> triggers;
    private List<Condition> conditions;
    private List<Action> actions;
    private Set<String> tags;
    private String label;
    private String description;
    private Visibility visibility;
    private List<ConfigDescriptionParameter> configDescriptions;

    public RuleTemplate(String UID, String label, String description, Set<String> tags, List<Trigger> triggers, List<Condition> conditions, List<Action> actions, List<ConfigDescriptionParameter> configDescriptions, Visibility visibility) {
        this.uid = UID;
        this.label = label;
        this.description = description;
        this.triggers = triggers;
        this.conditions = conditions;
        this.actions = actions;
        this.configDescriptions = configDescriptions;
        this.visibility = visibility;
        if (tags == null || tags.isEmpty()) {
            return;
        }
        this.tags = new HashSet<String>(tags);
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public Set<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptySet();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Visibility getVisibility() {
        if (this.visibility == null) {
            return Visibility.VISIBLE;
        }
        return this.visibility;
    }

    public List<ConfigDescriptionParameter> getConfigurationDescription() {
        return this.configDescriptions != null ? this.configDescriptions : Collections.emptyList();
    }

    public <T extends Module> T getModule(String id) {
        return null;
    }

    @Deprecated
    public <T extends Module> List<T> getModules(Class<T> moduleClazz) {
        List<Object> result = null;
        if (moduleClazz == null) {
            result = new ArrayList<Trigger>();
            result.addAll(this.triggers);
            result.addAll(this.conditions);
            result.addAll(this.actions);
        } else if (Trigger.class == moduleClazz) {
            result = this.triggers;
        } else if (Condition.class == moduleClazz) {
            result = this.conditions;
        } else if (Action.class == moduleClazz) {
            result = this.actions;
        }
        return result != null ? result : Collections.emptyList();
    }

    public List<Trigger> getTriggers() {
        return this.triggers != null ? this.triggers : Collections.emptyList();
    }

    public List<Condition> getConditions() {
        return this.conditions != null ? this.conditions : Collections.emptyList();
    }

    public List<Action> getActions() {
        return this.actions != null ? this.actions : Collections.emptyList();
    }
}

