/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.module.core.handler.CompareConditionHandler;
import org.eclipse.smarthome.automation.module.core.handler.EventConditionHandler;
import org.eclipse.smarthome.automation.module.core.handler.GenericEventTriggerHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemPostCommandActionHandler;
import org.eclipse.smarthome.automation.module.core.handler.ItemStateConditionHandler;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private Logger logger = LoggerFactory.getLogger(BasicModuleHandlerFactory.class);
    private static final Collection<String> types = Arrays.asList("ItemStateCondition", "ItemPostCommandAction", "GenericEventTrigger", "EventCondition", "GenericCompareCondition");
    private ServiceTracker itemRegistryTracker;
    private ServiceTracker eventPublisherTracker;
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.initializeServiceTrackers();
    }

    private void initializeServiceTrackers() {
        this.itemRegistryTracker = new ServiceTracker(this.bundleContext, ItemRegistry.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                BasicModuleHandlerFactory.this.setItemRegistry((ItemRegistry)BasicModuleHandlerFactory.this.bundleContext.getService(reference));
                return BasicModuleHandlerFactory.this.itemRegistry;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                BasicModuleHandlerFactory.this.unsetItemRegistry((ItemRegistry)service);
            }
        });
        this.itemRegistryTracker.open();
        this.eventPublisherTracker = new ServiceTracker(this.bundleContext, EventPublisher.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                BasicModuleHandlerFactory.this.setEventPublisher((EventPublisher)BasicModuleHandlerFactory.this.bundleContext.getService(reference));
                return BasicModuleHandlerFactory.this.eventPublisher;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                BasicModuleHandlerFactory.this.unsetEventPublisher((EventPublisher)service);
            }
        });
        this.eventPublisherTracker.open();
    }

    public Collection<String> getTypes() {
        return types;
    }

    private void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        for (ModuleHandler handler : this.handlers.values()) {
            if (handler instanceof ItemStateConditionHandler) {
                ((ItemStateConditionHandler)handler).setItemRegistry(this.itemRegistry);
                continue;
            }
            if (!(handler instanceof ItemPostCommandActionHandler)) continue;
            ((ItemPostCommandActionHandler)handler).setItemRegistry(this.itemRegistry);
        }
    }

    private void unsetItemRegistry(ItemRegistry itemRegistry) {
        for (ModuleHandler handler : this.handlers.values()) {
            if (handler instanceof ItemStateConditionHandler) {
                ((ItemStateConditionHandler)handler).unsetItemRegistry(this.itemRegistry);
                continue;
            }
            if (!(handler instanceof ItemPostCommandActionHandler)) continue;
            ((ItemPostCommandActionHandler)handler).unsetItemRegistry(this.itemRegistry);
        }
        this.itemRegistry = null;
    }

    private void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        for (ModuleHandler handler : this.handlers.values()) {
            if (!(handler instanceof ItemPostCommandActionHandler)) continue;
            ((ItemPostCommandActionHandler)handler).setEventPublisher(eventPublisher);
        }
    }

    private void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
        for (ModuleHandler handler : this.handlers.values()) {
            if (!(handler instanceof ItemPostCommandActionHandler)) continue;
            ((ItemPostCommandActionHandler)handler).unsetEventPublisher(eventPublisher);
        }
    }

    public void dispose() {
        super.dispose();
        this.itemRegistryTracker.close();
        this.eventPublisherTracker.close();
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        ModuleHandler handler = (ModuleHandler)this.handlers.get(String.valueOf(ruleUID) + module.getId());
        String moduleTypeUID = module.getTypeUID();
        if ("GenericEventTrigger".equals(moduleTypeUID) && module instanceof Trigger) {
            GenericEventTriggerHandler triggerHandler;
            GenericEventTriggerHandler genericEventTriggerHandler = triggerHandler = handler != null && handler instanceof GenericEventTriggerHandler ? (GenericEventTriggerHandler)handler : null;
            if (triggerHandler == null) {
                triggerHandler = new GenericEventTriggerHandler((Trigger)module, this.bundleContext);
                this.handlers.put(String.valueOf(ruleUID) + module.getId(), triggerHandler);
            }
            return triggerHandler;
        }
        if ("ItemStateCondition".equals(moduleTypeUID) && module instanceof Condition) {
            ItemStateConditionHandler conditionHandler;
            ItemStateConditionHandler itemStateConditionHandler = conditionHandler = handler != null && handler instanceof ItemStateConditionHandler ? (ItemStateConditionHandler)handler : null;
            if (conditionHandler == null) {
                conditionHandler = new ItemStateConditionHandler((Condition)module);
                conditionHandler.setItemRegistry(this.itemRegistry);
                this.handlers.put(String.valueOf(ruleUID) + module.getId(), conditionHandler);
            }
            return conditionHandler;
        }
        if ("ItemPostCommandAction".equals(moduleTypeUID) && module instanceof Action) {
            ItemPostCommandActionHandler postCommandActionHandler;
            ItemPostCommandActionHandler itemPostCommandActionHandler = postCommandActionHandler = handler != null && handler instanceof ItemPostCommandActionHandler ? (ItemPostCommandActionHandler)handler : null;
            if (postCommandActionHandler == null) {
                postCommandActionHandler = new ItemPostCommandActionHandler((Action)module);
                postCommandActionHandler.setEventPublisher(this.eventPublisher);
                postCommandActionHandler.setItemRegistry(this.itemRegistry);
                this.handlers.put(String.valueOf(ruleUID) + module.getId(), postCommandActionHandler);
            }
            return postCommandActionHandler;
        }
        if ("EventCondition".equals(moduleTypeUID) && module instanceof Condition) {
            EventConditionHandler eventConditionHandler;
            EventConditionHandler eventConditionHandler2 = eventConditionHandler = handler != null && handler instanceof EventConditionHandler ? (EventConditionHandler)handler : null;
            if (eventConditionHandler == null) {
                eventConditionHandler = new EventConditionHandler((Condition)module);
                this.handlers.put(String.valueOf(ruleUID) + module.getId(), eventConditionHandler);
            }
            return eventConditionHandler;
        }
        if ("GenericCompareCondition".equals(moduleTypeUID) && module instanceof Condition) {
            CompareConditionHandler compareConditionHandler;
            CompareConditionHandler compareConditionHandler2 = compareConditionHandler = handler != null && handler instanceof CompareConditionHandler ? (CompareConditionHandler)handler : null;
            if (compareConditionHandler == null) {
                compareConditionHandler = new CompareConditionHandler((Condition)module);
                this.handlers.put(String.valueOf(ruleUID) + module.getId(), compareConditionHandler);
            }
            return compareConditionHandler;
        }
        this.logger.error("The ModuleHandler is not supported:" + moduleTypeUID);
        return null;
    }
}

