/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptActionHandler;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptConditionHandler;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private Logger logger = LoggerFactory.getLogger(ScriptModuleHandlerFactory.class);
    private static final Collection<String> types = Arrays.asList("ScriptAction", "ScriptCondition");

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    public Collection<String> getTypes() {
        return types;
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        String moduleTypeUID = module.getTypeUID();
        if (moduleTypeUID != null) {
            if ("ScriptCondition".equals(moduleTypeUID) && module instanceof Condition) {
                ScriptConditionHandler handler = new ScriptConditionHandler((Condition)module);
                return handler;
            }
            if ("ScriptAction".equals(moduleTypeUID) && module instanceof Action) {
                ScriptActionHandler handler = new ScriptActionHandler((Action)module);
                return handler;
            }
            this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        } else {
            this.logger.error("ModuleType is not registered: {}", (Object)moduleTypeUID);
        }
        return null;
    }
}

