/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.ntp.discovery;

import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.binding.ntp.NtpBindingConstants;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingUID;

public class NtpDiscovery
extends AbstractDiscoveryService {
    public NtpDiscovery() throws IllegalArgumentException {
        super(NtpBindingConstants.SUPPORTED_THING_TYPES_UIDS, 10);
    }

    protected void startBackgroundDiscovery() {
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                NtpDiscovery.this.discoverNtp();
            }
        }, 1L, TimeUnit.SECONDS);
    }

    protected void startScan() {
        this.discoverNtp();
    }

    private void discoverNtp() {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("timeZone", TimeZone.getDefault().getID());
        ThingUID uid = new ThingUID(NtpBindingConstants.THING_TYPE_NTP, "local");
        if (uid != null) {
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel("Local Time").build();
            this.thingDiscovered(result);
        }
    }
}

