/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.normalization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.normalization.BooleanNormalizer;
import org.eclipse.smarthome.config.core.normalization.DecimalNormalizer;
import org.eclipse.smarthome.config.core.normalization.IntNormalizer;
import org.eclipse.smarthome.config.core.normalization.ListNormalizer;
import org.eclipse.smarthome.config.core.normalization.Normalizer;
import org.eclipse.smarthome.config.core.normalization.TextNormalizer;

public final class NormalizerFactory {
    private static final Map<ConfigDescriptionParameter.Type, Normalizer> normalizers = new ImmutableMap.Builder().put((Object)ConfigDescriptionParameter.Type.BOOLEAN, (Object)new BooleanNormalizer()).put((Object)ConfigDescriptionParameter.Type.TEXT, (Object)new TextNormalizer()).put((Object)ConfigDescriptionParameter.Type.INTEGER, (Object)new IntNormalizer()).put((Object)ConfigDescriptionParameter.Type.DECIMAL, (Object)new DecimalNormalizer()).build();

    private NormalizerFactory() {
    }

    public static Normalizer getNormalizer(ConfigDescriptionParameter configDescriptionParameter) {
        Preconditions.checkNotNull((Object)configDescriptionParameter, (Object)"The config description parameter must not be null.");
        Normalizer ret = normalizers.get((Object)configDescriptionParameter.getType());
        if (configDescriptionParameter.isMultiple().booleanValue()) {
            ret = new ListNormalizer(ret);
        }
        return ret;
    }
}

