/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;

public final class ConfigValidationMessage {
    public final String parameterName;
    public final String defaultMessage;
    public final String messageKey;
    public final Object[] content;

    public ConfigValidationMessage(String parameterName, String defaultMessage, String messageKey) {
        this(parameterName, defaultMessage, messageKey, Collections.emptyList());
    }

    public ConfigValidationMessage(String parameterName, String defaultMessage, String messageKey, Object ... content) {
        Preconditions.checkNotNull((Object)parameterName, (Object)"Parameter Name must not be null");
        Preconditions.checkNotNull((Object)defaultMessage, (Object)"Default message must not be null");
        Preconditions.checkNotNull((Object)messageKey, (Object)"Message key must not be null");
        Preconditions.checkNotNull((Object)content, (Object)"Content must not be null");
        this.parameterName = parameterName;
        this.defaultMessage = defaultMessage;
        this.messageKey = messageKey;
        this.content = content;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.content);
        result = 31 * result + (this.defaultMessage == null ? 0 : this.defaultMessage.hashCode());
        result = 31 * result + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        result = 31 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigValidationMessage other = (ConfigValidationMessage)obj;
        if (!Arrays.equals(this.content, other.content)) {
            return false;
        }
        if (this.defaultMessage == null ? other.defaultMessage != null : !this.defaultMessage.equals(other.defaultMessage)) {
            return false;
        }
        if (this.messageKey == null ? other.messageKey != null : !this.messageKey.equals(other.messageKey)) {
            return false;
        }
        return !(this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName));
    }

    public String toString() {
        return "ConfigDescriptionValidationMessage [parameterName=" + this.parameterName + ", defaultMessage=" + this.defaultMessage + ", messageKey=" + this.messageKey + ", content=" + Arrays.toString(this.content) + "]";
    }
}

