/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation.internal;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.validation.internal.MessageKey;

final class TypeIntrospections {
    private static final Map<ConfigDescriptionParameter.Type, TypeIntrospection> introspections = new ImmutableMap.Builder().put((Object)ConfigDescriptionParameter.Type.BOOLEAN, (Object)new BooleanIntrospection()).put((Object)ConfigDescriptionParameter.Type.TEXT, (Object)new StringIntrospection()).put((Object)ConfigDescriptionParameter.Type.INTEGER, (Object)new IntegerIntrospection()).put((Object)ConfigDescriptionParameter.Type.DECIMAL, (Object)new FloatIntrospection()).build();

    private TypeIntrospections() {
    }

    static TypeIntrospection get(ConfigDescriptionParameter.Type type) {
        TypeIntrospection typeIntrospection = introspections.get((Object)type);
        if (typeIntrospection == null) {
            throw new IllegalArgumentException("There is no type introspection for type " + (Object)((Object)type));
        }
        return typeIntrospection;
    }

    private static final class BooleanIntrospection
    extends TypeIntrospection {
        private BooleanIntrospection() {
            super(Boolean.class);
        }

        @Override
        boolean isMinViolated(Object value, int min) {
            throw new UnsupportedOperationException("Min attribute not supported for boolean parameter.");
        }

        @Override
        boolean isMaxViolated(Object value, int max) {
            throw new UnsupportedOperationException("Max attribute not supported for boolean parameter.");
        }
    }

    private static final class FloatIntrospection
    extends TypeIntrospection {
        private FloatIntrospection() {
            super(Float.class, MessageKey.MIN_VALUE_NUMERIC_VIOLATED, MessageKey.MAX_VALUE_NUMERIC_VIOLATED);
        }

        @Override
        boolean isAssignable(Object value) {
            if (!super.isAssignable(value)) {
                return this.isBigDecimalInstance(value);
            }
            return true;
        }

        @Override
        boolean isMinViolated(Object value, int min) {
            if (this.isBigDecimalInstance(value)) {
                return Float.compare(((BigDecimal)value).floatValue(), min) < 0;
            }
            return Float.compare(((Float)value).floatValue(), min) < 0;
        }

        @Override
        boolean isMaxViolated(Object value, int max) {
            if (this.isBigDecimalInstance(value)) {
                return Float.compare(((BigDecimal)value).floatValue(), max) > 0;
            }
            return Float.compare(((Float)value).floatValue(), max) > 0;
        }
    }

    private static final class IntegerIntrospection
    extends TypeIntrospection {
        private IntegerIntrospection() {
            super(Integer.class, MessageKey.MIN_VALUE_NUMERIC_VIOLATED, MessageKey.MAX_VALUE_NUMERIC_VIOLATED);
        }

        @Override
        boolean isAssignable(Object value) {
            if (!super.isAssignable(value)) {
                return this.isBigDecimalInstance(value);
            }
            return true;
        }

        @Override
        boolean isMinViolated(Object value, int min) {
            if (this.isBigDecimalInstance(value)) {
                return ((BigDecimal)value).intValueExact() < min;
            }
            return (Integer)value < min;
        }

        @Override
        boolean isMaxViolated(Object value, int max) {
            if (this.isBigDecimalInstance(value)) {
                return ((BigDecimal)value).intValueExact() > max;
            }
            return (Integer)value > max;
        }
    }

    private static final class StringIntrospection
    extends TypeIntrospection {
        private StringIntrospection() {
            super(String.class, MessageKey.MIN_VALUE_TXT_VIOLATED, MessageKey.MAX_VALUE_TXT_VIOLATED);
        }

        @Override
        boolean isMinViolated(Object value, int min) {
            return ((String)value).length() < min;
        }

        @Override
        boolean isMaxViolated(Object value, int max) {
            return ((String)value).length() > max;
        }
    }

    static abstract class TypeIntrospection {
        private final Class<?> clazz;
        private final MessageKey minViolationMessageKey;
        private final MessageKey maxViolationMessageKey;

        private TypeIntrospection(Class<?> clazz) {
            this(clazz, null, null);
        }

        private TypeIntrospection(Class<?> clazz, MessageKey minViolationMessageKey, MessageKey maxViolationMessageKey) {
            this.clazz = clazz;
            this.minViolationMessageKey = minViolationMessageKey;
            this.maxViolationMessageKey = maxViolationMessageKey;
        }

        abstract boolean isMinViolated(Object var1, int var2);

        abstract boolean isMaxViolated(Object var1, int var2);

        boolean isAssignable(Object value) {
            return this.clazz.isAssignableFrom(value.getClass());
        }

        final boolean isBigDecimalInstance(Object value) {
            return value instanceof BigDecimal;
        }

        final MessageKey getMinViolationMessageKey() {
            return this.minViolationMessageKey;
        }

        final MessageKey getMaxViolationMessageKey() {
            return this.maxViolationMessageKey;
        }
    }
}

