/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.xml.util.ConverterAttributeMapValidator;
import org.eclipse.smarthome.config.xml.util.ConverterValueMap;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeValue;

public class ConfigDescriptionParameterConverter
extends GenericUnmarshaller<ConfigDescriptionParameter> {
    private ConverterAttributeMapValidator attributeMapValidator = new ConverterAttributeMapValidator(new String[][]{{"name", "true"}, {"type", "true"}, {"min", "false"}, {"max", "false"}, {"step", "false"}, {"pattern", "false"}, {"required", "false"}, {"readOnly", "false"}, {"multiple", "false"}, {"groupName", "false"}, {"unit", "false"}});

    public ConfigDescriptionParameterConverter() {
        super(ConfigDescriptionParameter.class);
    }

    private ConfigDescriptionParameter.Type toType(String xmlType) {
        if (xmlType != null) {
            return ConfigDescriptionParameter.Type.valueOf((String)xmlType.toUpperCase());
        }
        return null;
    }

    private BigDecimal toNumber(String value) {
        try {
            if (value != null) {
                return new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            throw new ConversionException("The value '" + value + "' could not be converted to a decimal number.", (Throwable)e);
        }
        return null;
    }

    private Boolean toBoolean(String val) {
        if (val == null) {
            return null;
        }
        return new Boolean(val);
    }

    private Boolean falseIfNull(Boolean b) {
        return b != null ? b : false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigDescriptionParameter configDescriptionParam = null;
        Map<String, String> attributes = this.attributeMapValidator.readValidatedAttributes(reader);
        String name = attributes.get("name");
        ConfigDescriptionParameter.Type type = this.toType(attributes.get("type"));
        BigDecimal min = this.toNumber(attributes.get("min"));
        BigDecimal max = this.toNumber(attributes.get("max"));
        BigDecimal step = this.toNumber(attributes.get("step"));
        String patternString = attributes.get("pattern");
        Boolean required = this.toBoolean(attributes.get("required"));
        Boolean readOnly = this.falseIfNull(this.toBoolean(attributes.get("readOnly")));
        Boolean multiple = this.falseIfNull(this.toBoolean(attributes.get("multiple")));
        String groupName = attributes.get("groupName");
        String unit = attributes.get("unit");
        ConverterValueMap valueMap = new ConverterValueMap(reader, context);
        String parameterContext = valueMap.getString("context");
        if (required == null) {
            required = valueMap.getBoolean("required", false);
        }
        String defaultValue = valueMap.getString("default");
        String label = valueMap.getString("label");
        String description = valueMap.getString("description");
        Boolean advanced = valueMap.getBoolean("advanced", false);
        Boolean limitToOptions = valueMap.getBoolean("limitToOptions", true);
        Integer multipleLimit = valueMap.getInteger("multipleLimit");
        String unitLabel = null;
        if (unit == null) {
            unitLabel = valueMap.getString("unitLabel");
        }
        List<ParameterOption> options = this.readParameterOptions(valueMap.getObject("options"));
        List filterCriteria = (List)valueMap.getObject("filter");
        configDescriptionParam = ConfigDescriptionParameterBuilder.create((String)name, (ConfigDescriptionParameter.Type)type).withMinimum(min).withMaximum(max).withStepSize(step).withPattern(patternString).withRequired(required).withReadOnly(readOnly).withMultiple(multiple).withContext(parameterContext).withDefault(defaultValue).withLabel(label).withDescription(description).withOptions(options).withFilterCriteria(filterCriteria).withGroupName(groupName).withAdvanced(advanced).withLimitToOptions(limitToOptions).withMultipleLimit(multipleLimit).withUnit(unit).withUnitLabel(unitLabel).build();
        return configDescriptionParam;
    }

    private List<ParameterOption> readParameterOptions(Object rawNodeValueList) {
        if (rawNodeValueList instanceof List) {
            List list = (List)rawNodeValueList;
            ArrayList<ParameterOption> result = new ArrayList<ParameterOption>();
            for (Object object : list) {
                if (!(object instanceof NodeValue)) continue;
                NodeValue nodeValue = (NodeValue)object;
                String value = nodeValue.getAttributes().get("value");
                String label = nodeValue.getValue().toString();
                result.add(new ParameterOption(value, label));
            }
            return result;
        }
        return null;
    }
}

