/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.NodeAttributes;
import org.eclipse.smarthome.config.xml.util.NodeName;

public class NodeList
implements NodeName {
    private String nodeName;
    private Map<String, String> attributes;
    private List<?> list;

    public NodeList(String nodeName, Map<String, String> attributes, List<?> list) throws IllegalArgumentException {
        if (nodeName == null || nodeName.isEmpty()) {
            throw new IllegalArgumentException("The name of the node must neither be null nor empty!");
        }
        this.attributes = attributes;
        this.nodeName = nodeName;
        this.list = list;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<?> getList() {
        return this.list;
    }

    public List<String> getAttributes(String nodeName, String attributeName) throws ConversionException {
        return this.getAttributes(nodeName, attributeName, null);
    }

    public List<String> getAttributes(String nodeName, String attributeName, String formattedText) throws ConversionException {
        ArrayList<String> attributes = null;
        if (this.list != null) {
            attributes = new ArrayList<String>(this.list.size());
            if (formattedText == null || formattedText.isEmpty()) {
                formattedText = "%s";
            }
            for (NodeAttributes node : this.list) {
                if (nodeName.equals(node.getNodeName())) {
                    String attributeValue = node.getAttribute(attributeName);
                    if (attributeValue != null) {
                        attributes.add(String.format(formattedText, attributeValue));
                        continue;
                    }
                    throw new ConversionException("Missing attribute '" + attributeName + "' in '" + nodeName + "'!");
                }
                throw new ConversionException("Invalid attribute in '" + nodeName + "'!");
            }
        }
        return attributes;
    }

    public String toString() {
        return "NodeList [nodeName=" + this.nodeName + ", attributes=" + this.attributes + ", list=" + this.list + "]";
    }
}

