/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.persistence;

import java.util.Date;
import org.eclipse.smarthome.core.types.State;

public class FilterCriteria {
    private String itemName;
    private Date beginDate;
    private Date endDate;
    private int pageNumber = 0;
    private int pageSize = Integer.MAX_VALUE;
    private Operator operator = Operator.EQ;
    private Ordering ordering = Ordering.DESCENDING;
    private State state;

    public String getItemName() {
        return this.itemName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public State getState() {
        return this.state;
    }

    public FilterCriteria setItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public FilterCriteria setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public FilterCriteria setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public FilterCriteria setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public FilterCriteria setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public FilterCriteria setOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public FilterCriteria setOrdering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    public FilterCriteria setState(State state) {
        this.state = state;
        return this;
    }

    public static enum Operator {
        EQ("="),
        NEQ("!="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<=");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        String getSymbol() {
            return this.symbol;
        }
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

