/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;

public class ThingStatusInfo {
    private ThingStatus status;
    private ThingStatusDetail statusDetail;
    private String description;

    protected ThingStatusInfo() {
    }

    public ThingStatusInfo(ThingStatus status, ThingStatusDetail statusDetail, String description) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Thing status must not be null");
        }
        if (statusDetail == null) {
            throw new IllegalArgumentException("Thing status detail must not be null");
        }
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public ThingStatus getStatus() {
        return this.status;
    }

    public ThingStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return (Object)((Object)this.getStatus()) + (this.getStatusDetail() == ThingStatusDetail.NONE ? "" : " (" + (Object)((Object)this.getStatusDetail()) + ")") + (StringUtils.isBlank((String)this.getDescription()) ? "" : ": " + this.getDescription());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusDetail == null ? 0 : this.statusDetail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingStatusInfo other = (ThingStatusInfo)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.statusDetail == other.statusDetail;
    }
}

