/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.validation.ConfigDescriptionValidator;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingStatusInfoBuilder;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseThingHandler
implements ThingHandler {
    private static final String THING_HANDLER_THREADPOOL_NAME = "thingHandler";
    private final Logger logger = LoggerFactory.getLogger(BaseThingHandler.class);
    protected final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"thingHandler");
    protected ThingRegistry thingRegistry;
    protected ItemChannelLinkRegistry linkRegistry;
    protected BundleContext bundleContext;
    protected Thing thing;
    private ServiceTracker thingRegistryServiceTracker;
    private ServiceTracker linkRegistryServiceTracker;
    private ThingHandlerCallback callback;

    public BaseThingHandler(Thing thing) {
        this.thing = thing;
    }

    public void setBundleContext(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.thingRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingRegistry.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                BaseThingHandler.this.thingRegistry = (ThingRegistry)bundleContext.getService(reference);
                return BaseThingHandler.this.thingRegistry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference reference, Object service) {
                BaseThingHandler baseThingHandler = BaseThingHandler.this;
                synchronized (baseThingHandler) {
                    BaseThingHandler.this.thingRegistry = null;
                }
            }
        };
        this.thingRegistryServiceTracker.open();
        this.linkRegistryServiceTracker = new ServiceTracker(this.bundleContext, ItemChannelLinkRegistry.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                BaseThingHandler.this.linkRegistry = (ItemChannelLinkRegistry)((Object)bundleContext.getService(reference));
                return BaseThingHandler.this.linkRegistry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference reference, Object service) {
                BaseThingHandler baseThingHandler = BaseThingHandler.this;
                synchronized (baseThingHandler) {
                    BaseThingHandler.this.linkRegistry = null;
                }
            }
        };
        this.linkRegistryServiceTracker.open();
    }

    public void unsetBundleContext(BundleContext bundleContext) {
        this.thingRegistryServiceTracker.close();
        this.bundleContext = null;
    }

    @Override
    public void handleRemoval() {
        this.updateStatus(ThingStatus.REMOVED);
    }

    @Override
    public void handleConfigurationUpdate(Map<String, Object> configurationParameters) {
        this.validateConfigurationParameters(configurationParameters);
        Configuration configuration = this.editConfiguration();
        for (Map.Entry<String, Object> configurationParmeter : configurationParameters.entrySet()) {
            configuration.put(configurationParmeter.getKey(), configurationParmeter.getValue());
        }
        if (this.thingIsInitialized()) {
            this.dispose();
            this.updateConfiguration(configuration);
            this.initialize();
        } else {
            this.updateConfiguration(configuration);
            this.callback.configurationUpdated(this.getThing());
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public Thing getThing() {
        return this.thing;
    }

    @Override
    public void handleUpdate(ChannelUID channelUID, State newState) {
    }

    @Override
    public void initialize() {
        this.updateStatus(ThingStatus.ONLINE);
    }

    @Override
    public void thingUpdated(Thing thing) {
        this.dispose();
        this.thing = thing;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallback(ThingHandlerCallback thingHandlerCallback) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            this.callback = thingHandlerCallback;
        }
    }

    @Override
    public void channelLinked(ChannelUID channelUID) {
    }

    @Override
    public void channelUnlinked(ChannelUID channelUID) {
    }

    protected void validateConfigurationParameters(Map<String, Object> configurationParameters) {
        ThingType thingType = TypeResolver.resolve(this.getThing().getThingTypeUID());
        if (thingType != null && thingType.getConfigDescriptionURI() != null) {
            ConfigDescriptionValidator.validate(configurationParameters, (URI)thingType.getConfigDescriptionURI());
        }
    }

    protected Configuration getConfig() {
        return this.getThing().getConfiguration();
    }

    protected <T> T getConfigAs(Class<T> configurationClass) {
        return (T)this.getConfig().as(configurationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState(ChannelUID channelUID, State state) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback == null) {
                throw new IllegalStateException("Could not update state, because callback is missing");
            }
            this.callback.stateUpdated(channelUID, state);
        }
    }

    protected void updateState(String channelID, State state) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelID);
        this.updateState(channelUID, state);
    }

    protected void postCommand(String channelID, Command command) {
        ChannelUID channelUID = new ChannelUID(this.getThing().getUID(), channelID);
        this.postCommand(channelUID, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommand(ChannelUID channelUID, Command command) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback == null) {
                throw new IllegalStateException("Could not update state, because callback is missing");
            }
            this.callback.postCommand(channelUID, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(ThingStatus status, ThingStatusDetail statusDetail, String description) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback == null) {
                throw new IllegalStateException("Could not update status, because callback is missing");
            }
            ThingStatusInfoBuilder statusBuilder = ThingStatusInfoBuilder.create(status, statusDetail);
            ThingStatusInfo statusInfo = statusBuilder.withDescription(description).build();
            this.callback.statusUpdated(this.thing, statusInfo);
        }
    }

    protected void updateStatus(ThingStatus status, ThingStatusDetail statusDetail) {
        this.updateStatus(status, statusDetail, null);
    }

    protected void updateStatus(ThingStatus status) {
        this.updateStatus(status, ThingStatusDetail.NONE, null);
    }

    protected ThingBuilder editThing() {
        return (ThingBuilder)((ThingBuilder)((ThingBuilder)ThingBuilder.create(this.thing.getThingTypeUID(), this.thing.getUID()).withBridge(this.thing.getBridgeUID())).withChannels(this.thing.getChannels())).withConfiguration(this.thing.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateThing(Thing thing) {
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (this.callback == null) {
                throw new IllegalStateException("Could not update thing, because callback is missing");
            }
            this.thing = thing;
            this.callback.thingUpdated(thing);
        }
    }

    protected Configuration editConfiguration() {
        Map properties = this.thing.getConfiguration().getProperties();
        return new Configuration(new HashMap(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConfiguration(Configuration configuration) {
        Map old = this.thing.getConfiguration().getProperties();
        try {
            this.thing.getConfiguration().setProperties(configuration.getProperties());
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback == null) {
                    throw new IllegalStateException("Could not update configuration, because callback is missing");
                }
                this.callback.thingUpdated(this.thing);
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Error while applying configuration changes: '{}: {}' - reverting configuration changes on thing '{}'.", new Object[]{e.getClass().getSimpleName(), e.getMessage(), this.thing.getUID().getAsString()});
            this.thing.getConfiguration().setProperties(old);
            throw e;
        }
    }

    protected Map<String, String> editProperties() {
        Map<String, String> properties = this.thing.getProperties();
        return new HashMap<String, String>(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(Map<String, String> properties) {
        boolean propertiesUpdated = false;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            String propertyValue = property.getValue();
            String existingPropertyValue = this.thing.getProperties().get(propertyName);
            if (existingPropertyValue != null && existingPropertyValue.equals(propertyValue)) continue;
            this.thing.setProperty(propertyName, propertyValue);
            propertiesUpdated = true;
        }
        if (propertiesUpdated) {
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback == null) {
                    throw new IllegalStateException("Could not update properties, because callback is missing");
                }
                this.callback.thingUpdated(this.thing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperty(String name, String value) {
        String existingPropertyValue = this.thing.getProperties().get(name);
        if (existingPropertyValue == null || !existingPropertyValue.equals(value)) {
            this.thing.setProperty(name, value);
            BaseThingHandler baseThingHandler = this;
            synchronized (baseThingHandler) {
                if (this.callback == null) {
                    throw new IllegalStateException("Could not update properties, because callback is missing");
                }
                this.callback.thingUpdated(this.thing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bridge getBridge() {
        ThingUID bridgeUID = this.thing.getBridgeUID();
        BaseThingHandler baseThingHandler = this;
        synchronized (baseThingHandler) {
            if (bridgeUID != null && this.thingRegistry != null) {
                return (Bridge)this.thingRegistry.get(bridgeUID);
            }
            return null;
        }
    }

    protected boolean isLinked(String channelId) {
        Channel channel = this.thing.getChannel(channelId);
        if (channel != null) {
            return this.linkRegistry != null ? !this.linkRegistry.getLinks(channel.getUID()).isEmpty() : false;
        }
        throw new IllegalArgumentException("Channel with ID '" + channelId + "' does not exists.");
    }

    protected boolean thingIsInitialized() {
        return this.getThing().getStatus() == ThingStatus.ONLINE || this.getThing().getStatus() == ThingStatus.OFFLINE;
    }

    @Override
    public void bridgeHandlerInitialized(ThingHandler thingHandler, Bridge bridge) {
    }

    @Override
    public void bridgeHandlerDisposed(ThingHandler thingHandler, Bridge bridge) {
    }

    @Override
    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
    }

    protected void changeThingType(ThingTypeUID thingTypeUID, Configuration configuration) {
        if (this.callback == null) {
            throw new IllegalStateException("Could not change thing type because callback is missing");
        }
        this.callback.changeThingType(this.getThing(), thingTypeUID, configuration);
    }
}

