/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUpdateHandler;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseThingHandlerFactory
implements ThingHandlerFactory {
    protected BundleContext bundleContext;
    private Map<String, ServiceRegistration<ThingHandler>> thingHandlers = new HashMap<String, ServiceRegistration<ThingHandler>>();
    private Map<String, ServiceRegistration<ConfigStatusProvider>> configStatusProviders = new HashMap<String, ServiceRegistration<ConfigStatusProvider>>();
    private Map<String, ServiceRegistration<FirmwareUpdateHandler>> firmwareUpdateHandlers = new HashMap<String, ServiceRegistration<FirmwareUpdateHandler>>();
    private ServiceTracker<ThingTypeRegistry, ThingTypeRegistry> thingTypeRegistryServiceTracker;
    private ServiceTracker<ConfigDescriptionRegistry, ConfigDescriptionRegistry> configDescriptionRegistryServiceTracker;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.thingTypeRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingTypeRegistry.class.getName(), null);
        this.thingTypeRegistryServiceTracker.open();
        this.configDescriptionRegistryServiceTracker = new ServiceTracker(this.bundleContext, ConfigDescriptionRegistry.class.getName(), null);
        this.configDescriptionRegistryServiceTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        for (ServiceRegistration<ThingHandler> serviceRegistration : this.thingHandlers.values()) {
            this.unregisterHandler(serviceRegistration);
        }
        for (ServiceRegistration<ThingHandler> serviceRegistration : this.configStatusProviders.values()) {
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
        for (ServiceRegistration serviceRegistration : this.firmwareUpdateHandlers.values()) {
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
        this.thingTypeRegistryServiceTracker.close();
        this.configDescriptionRegistryServiceTracker.close();
        this.thingHandlers.clear();
        this.configStatusProviders.clear();
        this.firmwareUpdateHandlers.clear();
        this.bundleContext = null;
    }

    @Override
    public void unregisterHandler(Thing thing) {
        ServiceRegistration<FirmwareUpdateHandler> firmwareUpdateHandlerServiceRegistration;
        ServiceRegistration<ConfigStatusProvider> configStatusProviderServiceRegistration;
        ServiceRegistration<ThingHandler> thingHandlerServiceRegistration = this.thingHandlers.remove(thing.getUID().toString());
        if (thingHandlerServiceRegistration != null) {
            this.unregisterHandler(thingHandlerServiceRegistration);
        }
        if ((configStatusProviderServiceRegistration = this.configStatusProviders.remove(thing.getUID().getAsString())) != null) {
            configStatusProviderServiceRegistration.unregister();
        }
        if ((firmwareUpdateHandlerServiceRegistration = this.firmwareUpdateHandlers.remove(thing.getUID().getAsString())) != null) {
            firmwareUpdateHandlerServiceRegistration.unregister();
        }
    }

    private void unregisterHandler(ServiceRegistration<ThingHandler> serviceRegistration) {
        ThingHandler thingHandler = (ThingHandler)this.bundleContext.getService(serviceRegistration.getReference());
        this.removeHandler(thingHandler);
        serviceRegistration.unregister();
        if (thingHandler instanceof BaseThingHandler) {
            ((BaseThingHandler)thingHandler).unsetBundleContext(this.bundleContext);
        }
    }

    @Override
    public void registerHandler(Thing thing, ThingHandlerCallback thingHandlerListener) {
        ThingHandler thingHandler = this.createHandler(thing);
        if (thingHandler == null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " could not create a handler for the thing '" + thing.getUID() + "'.");
        }
        if (thingHandler instanceof BaseThingHandler) {
            if (this.bundleContext == null) {
                throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
            }
            ((BaseThingHandler)thingHandler).setBundleContext(this.bundleContext);
        }
        ServiceRegistration<ThingHandler> thingHandlderServiceRegistration = this.registerThingHandlerAsService(thing, thingHandler);
        this.thingHandlers.put(thing.getUID().toString(), thingHandlderServiceRegistration);
        if (thingHandler instanceof ConfigStatusProvider) {
            ServiceRegistration<ConfigStatusProvider> configStatusProviderServiceRegistration = this.registerConfigStatusProviderAsService(thingHandler);
            this.configStatusProviders.put(thing.getUID().getAsString(), configStatusProviderServiceRegistration);
        }
        if (thingHandler instanceof FirmwareUpdateHandler) {
            ServiceRegistration<FirmwareUpdateHandler> firmwareUpdateHandlerServiceRegistration = this.registerFirmwareUpdateHandlerAsService(thingHandler);
            this.firmwareUpdateHandlers.put(thing.getUID().getAsString(), firmwareUpdateHandlerServiceRegistration);
        }
    }

    private ServiceRegistration<ThingHandler> registerThingHandlerAsService(Thing thing, ThingHandler thingHandler) {
        Dictionary<String, Object> serviceProperties = this.getServiceProperties(thing, thingHandler);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ThingHandler.class.getName(), (Object)thingHandler, serviceProperties);
        return serviceRegistration;
    }

    private ServiceRegistration<ConfigStatusProvider> registerConfigStatusProviderAsService(ThingHandler thingHandler) {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ConfigStatusProvider.class.getName(), (Object)thingHandler, null);
        return serviceRegistration;
    }

    private ServiceRegistration<FirmwareUpdateHandler> registerFirmwareUpdateHandlerAsService(ThingHandler thingHandler) {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(FirmwareUpdateHandler.class.getName(), (Object)thingHandler, null);
        return serviceRegistration;
    }

    private Dictionary<String, Object> getServiceProperties(Thing thing, ThingHandler thingHandler) {
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("thing.id", thing.getUID());
        ((Dictionary)serviceProperties).put("thing.type", thing.getThingTypeUID().toString());
        Map<String, Object> additionalServiceProperties = this.getServiceProperties(thingHandler);
        if (additionalServiceProperties != null) {
            for (Map.Entry<String, Object> additionalServiceProperty : additionalServiceProperties.entrySet()) {
                ((Dictionary)serviceProperties).put(additionalServiceProperty.getKey(), additionalServiceProperty.getValue());
            }
        }
        return serviceProperties;
    }

    protected Map<String, Object> getServiceProperties(ThingHandler thingHandler) {
        return null;
    }

    protected abstract ThingHandler createHandler(Thing var1);

    protected void removeHandler(ThingHandler thingHandler) {
    }

    @Override
    public void removeThing(ThingUID thingUID) {
    }

    protected ThingType getThingTypeByUID(ThingTypeUID thingTypeUID) {
        if (this.thingTypeRegistryServiceTracker == null) {
            throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
        }
        ThingTypeRegistry thingTypeRegistry = (ThingTypeRegistry)this.thingTypeRegistryServiceTracker.getService();
        if (thingTypeRegistry != null) {
            return thingTypeRegistry.getThingType(thingTypeUID);
        }
        return null;
    }

    protected Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID) {
        return this.createThing(thingTypeUID, configuration, thingUID, null);
    }

    @Override
    public Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID) {
        ThingType thingType;
        if (thingTypeUID == null) {
            throw new IllegalArgumentException("Thing Type UID must not be null");
        }
        if (thingUID == null) {
            thingUID = ThingFactory.generateRandomThingUID(thingTypeUID);
        }
        if ((thingType = this.getThingTypeByUID(thingTypeUID)) != null) {
            Thing thing = ThingFactory.createThing(thingType, thingUID, configuration, bridgeUID, this.getConfigDescriptionRegistry());
            return thing;
        }
        return null;
    }

    protected ConfigDescriptionRegistry getConfigDescriptionRegistry() {
        if (this.configDescriptionRegistryServiceTracker == null) {
            throw new IllegalStateException("Config Description Registry has not been properly initialized. Did you forget to call super.activate()?");
        }
        return (ConfigDescriptionRegistry)this.configDescriptionRegistryServiceTracker.getService();
    }
}

