/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class ChannelBuilder {
    private ChannelUID channelUID;
    private String acceptedItemType;
    private Configuration configuration;
    private Set<String> defaultTags;
    private Map<String, String> properties;
    private String label;
    private String description;
    private ChannelTypeUID channelTypeUID;

    private ChannelBuilder(ChannelUID channelUID, String acceptedItemType, Set<String> defaultTags) {
        this.channelUID = channelUID;
        this.acceptedItemType = acceptedItemType;
        this.defaultTags = defaultTags;
    }

    public static ChannelBuilder create(ChannelUID channelUID, String acceptedItemType) {
        return new ChannelBuilder(channelUID, acceptedItemType, new HashSet<String>());
    }

    public ChannelBuilder withType(ChannelTypeUID channelTypeUID) {
        this.channelTypeUID = channelTypeUID;
        return this;
    }

    public ChannelBuilder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ChannelBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ChannelBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public ChannelBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ChannelBuilder withDefaultTags(Set<String> defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    public Channel build() {
        return new Channel(this.channelUID, this.channelTypeUID, this.acceptedItemType, this.configuration, this.defaultTags, this.properties, this.label, this.description);
    }
}

