/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.dto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.ChannelUID;

public class ChannelDTO {
    public String uid;
    public String id;
    public String channelTypeUID;
    public String itemType;
    public String label;
    public String description;
    public Set<String> defaultTags;
    public Map<String, String> properties;
    public Map<String, Object> configuration;

    public ChannelDTO() {
    }

    public ChannelDTO(ChannelUID uid, String channelTypeUID, String itemType, String label, String description, Map<String, String> properties, Configuration configuration, Set<String> defaultTags) {
        this.uid = uid.toString();
        this.id = uid.getId();
        this.channelTypeUID = channelTypeUID;
        this.itemType = itemType;
        this.label = label;
        this.description = description;
        this.properties = properties;
        this.configuration = this.toMap(configuration);
        this.defaultTags = new HashSet<String>(defaultTags);
    }

    private Map<String, Object> toMap(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        HashMap<String, Object> configurationMap = new HashMap<String, Object>(configuration.keySet().size());
        for (String key : configuration.keySet()) {
            configurationMap.put(key, configuration.get(key));
        }
        return configurationMap;
    }
}

