/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.dto;

import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class ChannelDTOMapper {
    public static ChannelDTO map(Channel channel) {
        ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
        String channelTypeUIDValue = channelTypeUID != null ? channelTypeUID.toString() : null;
        return new ChannelDTO(channel.getUID(), channelTypeUIDValue, channel.getAcceptedItemType().toString(), channel.getLabel(), channel.getDescription(), channel.getProperties(), channel.getConfiguration(), channel.getDefaultTags());
    }

    public static Channel map(ChannelDTO channelDTO) {
        ChannelUID channelUID = new ChannelUID(channelDTO.uid);
        ChannelTypeUID channelTypeUID = new ChannelTypeUID(channelDTO.channelTypeUID);
        return ChannelBuilder.create(channelUID, channelDTO.itemType).withConfiguration(new Configuration(channelDTO.configuration)).withLabel(channelDTO.label).withDescription(channelDTO.description).withProperties(channelDTO.properties).withType(channelTypeUID).withDefaultTags(channelDTO.defaultTags).build();
    }
}

