/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatusInfoEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfoEvent;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfoEvent;

public final class FirmwareEventFactory
extends AbstractEventFactory {
    private static final int THING_UID_TOPIC_IDX = 2;
    private static final String THING_UID_TOPIC_KEY = "{thingUID}";
    private static final String FIRMWARE_STATUS_TOPIC = "smarthome/things/{thingUID}/firmware/status";
    private static final String FIRMWARE_UPDATE_PROGRESS_TOPIC = "smarthome/things/{thingUID}/firmware/update/progress";
    private static final String FIRMWARE_UPDATE_RESULT_TOPIC = "smarthome/things/{thingUID}/firmware/update/result";

    public FirmwareEventFactory() {
        super((Set)ImmutableSet.of((Object)FirmwareStatusInfoEvent.TYPE, (Object)FirmwareUpdateProgressInfoEvent.TYPE, (Object)FirmwareUpdateResultInfoEvent.TYPE));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        if (FirmwareStatusInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareStatusInfoEvent(topic, payload);
        }
        if (FirmwareUpdateProgressInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareUpdateProgressInfoEvent(topic, payload);
        }
        if (FirmwareUpdateResultInfoEvent.TYPE.equals(eventType)) {
            return FirmwareEventFactory.createFirmwareUpdateResultInfoEvent(topic, payload);
        }
        return null;
    }

    static FirmwareStatusInfoEvent createFirmwareStatusInfoEvent(FirmwareStatusInfo firmwareStatusInfo, ThingUID thingUID) {
        Preconditions.checkNotNull((Object)firmwareStatusInfo, (Object)"The firmare status info must not be null.");
        Preconditions.checkNotNull((Object)thingUID, (Object)"The thing UID must not be null");
        String topic = FIRMWARE_STATUS_TOPIC.replace(THING_UID_TOPIC_KEY, thingUID.getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)firmwareStatusInfo);
        return new FirmwareStatusInfoEvent(topic, payload, firmwareStatusInfo, thingUID);
    }

    static FirmwareUpdateProgressInfoEvent createFirmwareUpdateProgressInfoEvent(FirmwareUpdateProgressInfo progressInfo, ThingUID thingUID) {
        Preconditions.checkNotNull((Object)progressInfo, (Object)"The progress info must not be null");
        Preconditions.checkNotNull((Object)thingUID, (Object)"The thing UID must not be null");
        String topic = FIRMWARE_UPDATE_PROGRESS_TOPIC.replace(THING_UID_TOPIC_KEY, thingUID.getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)progressInfo);
        return new FirmwareUpdateProgressInfoEvent(topic, payload, progressInfo, thingUID);
    }

    static FirmwareUpdateResultInfoEvent createFirmwareUpdateResultInfoEvent(FirmwareUpdateResultInfo firmwareUpdateResultInfo, ThingUID thingUID) {
        Preconditions.checkNotNull((Object)firmwareUpdateResultInfo, (Object)"The firmware update result info must not be null");
        Preconditions.checkNotNull((Object)thingUID, (Object)"The thing UID must not be null");
        String topic = FIRMWARE_UPDATE_RESULT_TOPIC.replace(THING_UID_TOPIC_KEY, thingUID.getAsString());
        String payload = FirmwareEventFactory.serializePayload((Object)firmwareUpdateResultInfo);
        return new FirmwareUpdateResultInfoEvent(topic, payload, firmwareUpdateResultInfo, thingUID);
    }

    private static FirmwareStatusInfoEvent createFirmwareStatusInfoEvent(String topic, String payload) {
        FirmwareStatusInfo firmwareStatusInfo = (FirmwareStatusInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareStatusInfo.class);
        return new FirmwareStatusInfoEvent(topic, payload, firmwareStatusInfo, FirmwareEventFactory.getThingUID(topic));
    }

    private static FirmwareUpdateProgressInfoEvent createFirmwareUpdateProgressInfoEvent(String topic, String payload) {
        FirmwareUpdateProgressInfo firmwareUpdateProgressInfo = (FirmwareUpdateProgressInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareUpdateProgressInfo.class);
        return new FirmwareUpdateProgressInfoEvent(topic, payload, firmwareUpdateProgressInfo, FirmwareEventFactory.getThingUID(topic));
    }

    private static FirmwareUpdateResultInfoEvent createFirmwareUpdateResultInfoEvent(String topic, String payload) {
        FirmwareUpdateResultInfo firmwareUpdateResultInfo = (FirmwareUpdateResultInfo)FirmwareEventFactory.deserializePayload((String)payload, FirmwareUpdateResultInfo.class);
        return new FirmwareUpdateResultInfoEvent(topic, payload, firmwareUpdateResultInfo, FirmwareEventFactory.getThingUID(topic));
    }

    private static ThingUID getThingUID(String topic) {
        String thingUID = topic.split("/")[2];
        return new ThingUID(thingUID);
    }
}

